/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.filter;

import de.esoco.lib.expression.function.RelationAccessor;
import de.esoco.lib.property.Gettable;
import de.esoco.lib.property.HasValue;
import de.esoco.lib.property.Settable;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.obrel.core.Relatable;
import org.obrel.core.Relation;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;

public class RelationCoupling<T> {
    public static final RelationType<Set<RelationCoupling<?>>> COUPLINGS = RelationTypes.newSetType(false, new RelationTypeModifier[0]);
    private final Relatable rRelatable;
    private final RelationType<T> rType;
    private Consumer<T> fUpdateTarget;
    private Supplier<T> fQuerySource;

    private RelationCoupling(Relatable rRelatable, RelationType<T> rType, Consumer<T> fUpdateTarget, Supplier<T> fQuerySource) {
        if (fUpdateTarget == null && fQuerySource == null) {
            throw new IllegalArgumentException("At least one coupling function must be provided");
        }
        this.rRelatable = rRelatable;
        this.rType = rType;
        this.fUpdateTarget = fUpdateTarget;
        this.fQuerySource = fQuerySource;
    }

    public static <T> RelationCoupling<T> couple(Relatable rRelatable, RelationType<T> rType, Consumer<T> fUpdateTarget, Supplier<T> fQuerySource) {
        RelationCoupling<T> aCoupling = new RelationCoupling<T>(rRelatable, rType, fUpdateTarget, fQuerySource);
        rRelatable.init(rType).get(COUPLINGS).add(aCoupling);
        return aCoupling;
    }

    public static <T> RelationCoupling<T> couple(Relatable rRelatable, RelationType<T> rType, Relatable rCoupledRelatable, RelationType<T> rCoupledType) {
        RelationAccessor<T> fTarget = new RelationAccessor<T>(rCoupledRelatable, rCoupledType);
        return RelationCoupling.couple(rRelatable, rType, fTarget, fTarget);
    }

    public static <T> RelationCoupling<T> coupleSource(Relatable rRelatable, RelationType<T> rType, Supplier<T> fQuerySource) {
        return RelationCoupling.couple(rRelatable, rType, null, fQuerySource);
    }

    public static <T> RelationCoupling<T> coupleTarget(Relatable rRelatable, RelationType<T> rType, Consumer<T> fUpdateTarget) {
        return RelationCoupling.couple(rRelatable, rType, fUpdateTarget, null);
    }

    public static <T> RelationCoupling<T> coupleValue(Relatable rRelatable, RelationType<T> rType, HasValue<T> rValueHolder) {
        return RelationCoupling.coupleValue(rRelatable, rType, rValueHolder, rValueHolder);
    }

    public static <T> RelationCoupling<T> coupleValue(Relatable rRelatable, RelationType<T> rType, Settable<T> fSettable, Gettable<T> fGettable) {
        Consumer<Object> fSet = arg_0 -> fSettable.setValue(arg_0);
        Supplier<Object> fGet = () -> fGettable.getValue();
        return RelationCoupling.couple(rRelatable, rType, fSet, fGet);
    }

    public static void getAll(Relatable rRelatable, Collection<RelationType<?>> rTypes) {
        RelationCoupling.couplings(rRelatable, rTypes).forEach(s -> s.forEach(c -> c.get()));
    }

    public static void removeAll(Relatable rRelatable, Collection<RelationType<?>> rTypes) {
        RelationCoupling.couplings(rRelatable, rTypes).forEach(s -> s.forEach(c -> c.remove()));
    }

    public static void setAll(Relatable rRelatable, Collection<RelationType<?>> rTypes) {
        RelationCoupling.couplings(rRelatable, rTypes).forEach(s -> s.forEach(c -> c.set()));
    }

    private static Stream<Set<RelationCoupling<?>>> couplings(Relatable rRelatable, Collection<RelationType<?>> rTypes) {
        Stream<Set<RelationCoupling<?>>> rCouplings = rRelatable.getRelations().stream().filter(r -> rTypes.contains(r.getType()) && r.hasRelation(COUPLINGS)).map(r -> r.get(COUPLINGS));
        return rCouplings;
    }

    public T get() {
        if (this.fQuerySource != null) {
            return this.rRelatable.set(this.rType, this.fQuerySource.get()).getTarget();
        }
        return this.rRelatable.get(this.rType);
    }

    public void remove() {
        Relation<Set<RelationCoupling<?>>> rRelation = this.rRelatable.getRelation(this.rType);
        this.fUpdateTarget = null;
        this.fQuerySource = null;
        if (rRelation != null) {
            rRelation.get(COUPLINGS).remove(this);
        }
    }

    public void set() {
        if (this.fUpdateTarget != null) {
            this.fUpdateTarget.accept(this.rRelatable.get(this.rType));
        }
    }

    static {
        RelationTypes.init(RelationCoupling.class);
    }
}

