/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.filter;

import de.esoco.lib.expression.CollectionPredicates;
import de.esoco.lib.expression.Predicate;
import de.esoco.lib.expression.Predicates;
import java.util.Collection;
import org.obrel.core.Relation;
import org.obrel.core.RelationType;

public class RelationFilters {
    public static final Predicate<Relation<?>> ALL_RELATIONS = Predicates.alwaysTrue();

    private RelationFilters() {
    }

    public static Predicate<Relation<?>> ifType(Predicate<RelationType<?>> rTypePredicate) {
        return r -> rTypePredicate.test(r.getType());
    }

    public static Predicate<Relation<?>> ifType(RelationType<?> rType) {
        return RelationFilters.ifType(t -> t == rType);
    }

    public static Predicate<Relation<?>> ifTypeNot(RelationType<?> rType) {
        return RelationFilters.ifType(t -> t != rType);
    }

    public static Predicate<Relation<?>> withAnnotation(Predicate<Relation<?>> rAnnotationFilter) {
        return r -> r.hasRelations(rAnnotationFilter);
    }

    public static Predicate<Relation<?>> withTarget(Predicate<Object> rTargetPredicate) {
        return r -> (Boolean)rTargetPredicate.evaluate(r.getTarget());
    }

    public static Predicate<Relation<?>> withTypeIn(Collection<RelationType<?>> rTypes) {
        return RelationFilters.ifType(CollectionPredicates.elementOf(rTypes));
    }
}

