/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.space;

import de.esoco.lib.expression.Function;
import java.io.File;
import org.obrel.space.RelationSpace;

public class FileSystemSpace<T>
extends RelationSpace<T> {
    private final String sRootPath;
    private final String sDefaultFile;
    private final Function<File, T> fReadFile;

    public FileSystemSpace(String sRootPath, String sDefaultFile, Function<File, T> fReadFile) {
        if (!sRootPath.endsWith("/")) {
            sRootPath = sRootPath + "/";
        }
        this.sRootPath = sRootPath;
        this.sDefaultFile = sDefaultFile;
        this.fReadFile = fReadFile;
    }

    @Override
    public T get(String sUrl) {
        File aFile;
        if (sUrl.startsWith("/")) {
            sUrl = sUrl.substring(1);
        }
        if (sUrl.isEmpty()) {
            sUrl = this.sDefaultFile;
        }
        if (!(aFile = new File(this.sRootPath + sUrl)).exists() || !aFile.isFile() || aFile.isHidden()) {
            throw new IllegalArgumentException("Invalid URL: " + sUrl);
        }
        return this.fReadFile.evaluate(aFile);
    }
}

