/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.space;

import de.esoco.lib.text.TextConvert;
import java.text.DateFormat;
import java.util.Date;
import org.obrel.core.Relatable;
import org.obrel.core.Relation;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;
import org.obrel.space.ObjectSpace;
import org.obrel.space.RelationSpace;
import org.obrel.type.StandardTypes;

public class HtmlSpace
extends RelationSpace<String> {
    public static final RelationType<String> PAGE_TEMPLATE = RelationTypes.newInitialValueType("<!DOCTYPE html>\n<html>\n<head>\n<title>%s</title>\n</head>\n<body>\n%s</body>\n</html>", new RelationTypeModifier[0]);
    public static final RelationType<String> INTERNAL_LINK_TEMPLATE = RelationTypes.newInitialValueType("<a href=\"%s\">%s</a>", new RelationTypeModifier[0]);
    public static final RelationType<String> TEXT_DISPLAY_TEMPLATE = RelationTypes.newInitialValueType("<b>%s</b>: %s", new RelationTypeModifier[0]);
    private final ObjectSpace<?> rDataSpace;
    private final String sBaseUrl;

    public HtmlSpace(ObjectSpace<?> rDataSpace, String sBaseUrl) {
        this.rDataSpace = rDataSpace;
        this.sBaseUrl = this.checkUrl(sBaseUrl);
    }

    @Override
    public String get(String sUrl) {
        Object rValue = this.rDataSpace.get(sUrl);
        if (rValue != null) {
            return this.renderAsHtml(sUrl, rValue);
        }
        throw new IllegalArgumentException("Not found: " + sUrl);
    }

    @Override
    public void put(String sUrl, String sValue) {
    }

    @Override
    public String toString() {
        return this.renderAsHtml("", this.rDataSpace);
    }

    public <T> HtmlSpace with(RelationType<T> rType, T rValue) {
        this.set(rType, rValue);
        return this;
    }

    protected String checkUrl(String sUrl) {
        if (sUrl.length() > 0 && !sUrl.endsWith("/")) {
            sUrl = sUrl + "/";
        }
        return sUrl;
    }

    protected String getPageTitle(Relatable rPageObject) {
        String sTitle = rPageObject.get(StandardTypes.NAME);
        if (sTitle == null) {
            sTitle = rPageObject.getClass().getSimpleName();
        }
        return sTitle;
    }

    protected String renderAsHtml(String sUrl, Object rObject) {
        String sHtml;
        if (rObject instanceof HtmlSpace) {
            sHtml = rObject.toString();
        } else {
            String sBody;
            String sTitle;
            if (rObject instanceof Relatable) {
                Relatable rPageObject = (Relatable)rObject;
                sTitle = this.getPageTitle(rObject == this.rDataSpace ? this : rPageObject);
                sBody = this.renderRelations(this.sBaseUrl + this.checkUrl(sUrl), rPageObject);
            } else {
                sTitle = sUrl.substring(sUrl.lastIndexOf(47) + 1);
                sBody = this.renderDisplayValue(rObject);
            }
            sHtml = String.format(this.get(PAGE_TEMPLATE), sTitle, sBody);
        }
        return sHtml;
    }

    protected String renderRelation(String sUrl, Relation<?> rRelation) {
        Object rValue = rRelation.getTarget();
        String sHtml = null;
        if (rValue instanceof Relatable) {
            String sType = rRelation.getType().getSimpleName().toLowerCase();
            sHtml = String.format(this.get(INTERNAL_LINK_TEMPLATE), sType, sType);
        } else {
            String sLabel = rRelation.getType().getSimpleName();
            String sValue = this.renderDisplayValue(rValue);
            if (sValue != null) {
                sLabel = TextConvert.capitalize((String)sLabel, (String)" ");
                sHtml = String.format(this.get(TEXT_DISPLAY_TEMPLATE), sLabel, sValue);
            }
        }
        return sHtml;
    }

    protected String renderRelations(String sUrl, Relatable rRelatable) {
        StringBuilder aHtml = new StringBuilder();
        rRelatable.getRelations(null).stream().filter(r -> r.getType() != StandardTypes.NAME).forEach(rRelation -> {
            String sRelation = this.renderRelation(sUrl, (Relation<?>)rRelation);
            if (sRelation != null) {
                aHtml.append(sRelation).append("<br>");
            }
        });
        return aHtml.toString();
    }

    private String renderDisplayValue(Object rValue) {
        String sHtml = null;
        if (rValue instanceof Date) {
            sHtml = DateFormat.getDateTimeInstance().format(rValue);
        } else if (rValue != null) {
            sHtml = rValue.toString();
        }
        return sHtml;
    }

    static {
        RelationTypes.init(HtmlSpace.class);
    }
}

