/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.space;

import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.InvertibleFunction;
import de.esoco.lib.expression.Predicate;
import java.util.List;
import org.obrel.core.Relation;
import org.obrel.core.RelationType;
import org.obrel.core.TransformedRelation;
import org.obrel.space.ObjectSpace;

public class MappedSpace<I, O>
implements ObjectSpace<I> {
    private final ObjectSpace<O> rWrappedSpace;
    private final Function<O, I> fValueMapper;
    private InvertibleFunction<O, I> fPutMapper = null;

    public MappedSpace(ObjectSpace<O> rWrappedSpace, Function<O, I> fValueMapper) {
        this.rWrappedSpace = rWrappedSpace;
        this.fValueMapper = fValueMapper;
        if (fValueMapper instanceof InvertibleFunction) {
            this.fPutMapper = (InvertibleFunction)fValueMapper;
        }
    }

    @Override
    public void delete(String sUrl) {
        this.rWrappedSpace.delete(sUrl);
    }

    @Override
    public void deleteRelation(Relation<?> rRelation) {
        this.rWrappedSpace.deleteRelation(rRelation);
    }

    @Override
    public I get(String sUrl) {
        return this.fValueMapper.evaluate(this.rWrappedSpace.get(sUrl));
    }

    @Override
    public <T> T get(RelationType<T> rType) {
        return this.rWrappedSpace.get(rType);
    }

    @Override
    public <T> Relation<T> getRelation(RelationType<T> rType) {
        return this.rWrappedSpace.getRelation(rType);
    }

    @Override
    public List<Relation<?>> getRelations(Predicate<? super Relation<?>> rFilter) {
        return this.rWrappedSpace.getRelations(rFilter);
    }

    public final Function<O, I> getValueMapper() {
        return this.fValueMapper;
    }

    public final ObjectSpace<O> getWrappedSpace() {
        return this.rWrappedSpace;
    }

    @Override
    public void put(String sUrl, I rValue) {
        if (this.fPutMapper == null) {
            throw new UnsupportedOperationException("Value mapping not invertible");
        }
        this.rWrappedSpace.put(sUrl, this.fPutMapper.invert(rValue));
    }

    @Override
    public <T> Relation<T> set(RelationType<T> rType, T rTarget) {
        return this.rWrappedSpace.set(rType, rTarget);
    }

    public <T, V> Relation<T> set(RelationType<T> rType, Function<V, T> fTargetResolver, V rIntermediateTarget) {
        return this.rWrappedSpace.set(rType, fTargetResolver, rIntermediateTarget);
    }

    public String toString() {
        return this.getWrappedSpace().toString();
    }

    @Override
    public <T, D> TransformedRelation<T, D> transform(RelationType<T> rType, InvertibleFunction<T, D> fTransformation) {
        return this.rWrappedSpace.transform(rType, fTransformation);
    }
}

