/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.space;

import de.esoco.lib.expression.BinaryFunction;
import org.obrel.core.Relatable;
import org.obrel.core.RelationType;
import org.obrel.space.ObjectSpace;

public interface ObjectSpaceResolver
extends BinaryFunction<Relatable, RelationType<?>, Object> {
    public static final DeleteResolver URL_DELETE = (r, t) -> {
        r.deleteRelation((RelationType<?>)t);
        return null;
    };
    public static final GetResolver URL_GET = (r, t) -> r.get(t);

    public Object resolve(ObjectSpace<?> var1, String var2);

    public static class PutResolver<T>
    implements ObjectSpaceResolver {
        private final T rValue;

        public PutResolver(T rValue) {
            this.rValue = rValue;
        }

        @Override
        public Object evaluate(Relatable rRelatable, RelationType<?> rType) {
            T rValue = this.getValue();
            if (!rType.getTargetType().isAssignableFrom(rValue.getClass())) {
                String sMessage = String.format("Invalid value for type '%s': %s", rType, rValue);
                throw new IllegalArgumentException(sMessage);
            }
            rRelatable.set(rType, rValue);
            return null;
        }

        public T getValue() {
            return this.rValue;
        }

        @Override
        public Object resolve(ObjectSpace<?> rSpace, String sRelativeUrl) {
            rSpace.put(sRelativeUrl, this.rValue);
            return null;
        }
    }

    @FunctionalInterface
    public static interface GetResolver
    extends ObjectSpaceResolver {
        @Override
        default public Object resolve(ObjectSpace<?> rSpace, String sRelativeUrl) {
            return rSpace.get(sRelativeUrl);
        }
    }

    @FunctionalInterface
    public static interface DeleteResolver
    extends ObjectSpaceResolver {
        @Override
        default public Object resolve(ObjectSpace<?> rSpace, String sRelativeUrl) {
            rSpace.delete(sRelativeUrl);
            return null;
        }
    }
}

