/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.space;

import org.obrel.core.ObjectRelations;
import org.obrel.core.RelatedObject;
import org.obrel.space.ObjectSpace;
import org.obrel.space.ObjectSpaceResolver;
import org.obrel.type.StandardTypes;

public class RelationSpace<T>
extends RelatedObject
implements ObjectSpace<T> {
    private final boolean bModificationAllowed;

    public RelationSpace() {
        this(false);
    }

    public RelationSpace(boolean bModificationAllowed) {
        this.bModificationAllowed = bModificationAllowed;
    }

    @Override
    public void delete(String sUrl) {
        if (!this.bModificationAllowed) {
            throw new UnsupportedOperationException("Modification not allowed");
        }
        ObjectRelations.urlResolve(this, sUrl, false, ObjectSpaceResolver.URL_DELETE);
    }

    @Override
    public T get(String sUrl) {
        return (T)ObjectRelations.urlResolve(this, sUrl, false, ObjectSpaceResolver.URL_GET);
    }

    @Override
    public void put(String sUrl, T rValue) {
        if (!this.bModificationAllowed) {
            throw new UnsupportedOperationException("Modification not allowed");
        }
        ObjectRelations.urlResolve(this, sUrl, false, new ObjectSpaceResolver.PutResolver<T>(rValue));
    }

    @Override
    public String toString() {
        return this.get(StandardTypes.NAME);
    }
}

