/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.space;

import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.Functions;
import de.esoco.lib.expression.InvertibleFunction;
import de.esoco.lib.expression.Predicate;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.obrel.core.Relation;
import org.obrel.core.RelationType;
import org.obrel.core.TransformedRelation;
import org.obrel.space.MappedSpace;
import org.obrel.space.ObjectSpace;

public class SynchronizedObjectSpace<O>
extends MappedSpace<O, O> {
    ReadWriteLock aAccessLock = new ReentrantReadWriteLock();

    public SynchronizedObjectSpace(ObjectSpace<O> rWrappedSpace) {
        super(rWrappedSpace, Functions.identity());
    }

    @Override
    public void delete(String sUrl) {
        this.synchronizedModification(() -> super.delete(sUrl));
    }

    @Override
    public void deleteRelation(Relation<?> rRelation) {
        this.synchronizedModification(() -> super.deleteRelation(rRelation));
    }

    @Override
    public O get(String sUrl) {
        return (O)this.synchronizedGet(() -> super.get(sUrl));
    }

    @Override
    public <T> T get(RelationType<T> rType) {
        return (T)this.synchronizedGet(() -> super.get(rType));
    }

    @Override
    public <T> Relation<T> getRelation(RelationType<T> rType) {
        return this.synchronizedGet(() -> super.getRelation(rType));
    }

    @Override
    public List<Relation<?>> getRelations(Predicate<? super Relation<?>> rFilter) {
        return this.synchronizedGet(() -> super.getRelations(rFilter));
    }

    @Override
    public void put(String sUrl, O rValue) {
        this.synchronizedModification(() -> super.put(sUrl, rValue));
    }

    @Override
    public <T> Relation<T> set(RelationType<T> rType, T rTarget) {
        return this.synchronizedUpdate(() -> super.set(rType, rTarget));
    }

    @Override
    public <T, V> Relation<T> set(RelationType<T> rType, Function<V, T> fTargetResolver, V rIntermediateTarget) {
        return this.synchronizedUpdate(() -> super.set(rType, fTargetResolver, rIntermediateTarget));
    }

    @Override
    public <T, D> TransformedRelation<T, D> transform(RelationType<T> rType, InvertibleFunction<T, D> fTransformation) {
        return this.synchronizedUpdate(() -> super.transform(rType, fTransformation));
    }

    <T> T synchronizedGet(Supplier<T> fAccess) {
        this.aAccessLock.readLock().lock();
        try {
            T t = fAccess.get();
            return t;
        }
        finally {
            this.aAccessLock.readLock().unlock();
        }
    }

    void synchronizedModification(Runnable fUpdate) {
        this.aAccessLock.writeLock().lock();
        try {
            fUpdate.run();
        }
        finally {
            this.aAccessLock.writeLock().unlock();
        }
    }

    <T> T synchronizedUpdate(Supplier<T> fSet) {
        this.aAccessLock.writeLock().lock();
        try {
            T t = fSet.get();
            return t;
        }
        finally {
            this.aAccessLock.writeLock().unlock();
        }
    }
}

