/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.type;

import de.esoco.lib.collection.CollectionUtil;
import de.esoco.lib.collection.ImmutableCollection;
import de.esoco.lib.event.ElementEvent;
import de.esoco.lib.expression.BinaryFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.obrel.core.Relatable;
import org.obrel.core.Relation;
import org.obrel.core.RelationEvent;
import org.obrel.core.RelationTypeModifier;
import org.obrel.type.AutomaticType;
import org.obrel.type.MetaTypes;
import org.obrel.type.StandardTypes;

public class CollectorType<T>
extends AutomaticType<Collection<T>> {
    private static final long serialVersionUID = 1L;
    private final BinaryFunction<Relation<?>, Object, T> fCollector;
    private final boolean bDistinctValues;

    public CollectorType(String sName, Class<? super T> rCollectedType, BinaryFunction<Relation<?>, Object, T> fCollector, boolean bDistinctValues, RelationTypeModifier ... rModifiers) {
        super(sName, bDistinctValues ? Set.class : List.class, (? super Relatable o) -> bDistinctValues ? new LinkedHashSet() : new ArrayList(), rModifiers);
        this.fCollector = fCollector;
        this.bDistinctValues = bDistinctValues;
        this.set(MetaTypes.ELEMENT_DATATYPE, rCollectedType);
    }

    public static <T> CollectorType<T> newCollector(Class<? super T> rCollectedType, BinaryFunction<Relation<?>, Object, T> fCollector, RelationTypeModifier ... rModifiers) {
        return new CollectorType<T>(null, rCollectedType, fCollector, false, rModifiers);
    }

    public static <T> CollectorType<T> newDistinctCollector(Class<? super T> rCollectedType, BinaryFunction<Relation<?>, Object, T> fCollector, RelationTypeModifier ... rModifiers) {
        return new CollectorType<T>(null, rCollectedType, fCollector, true, rModifiers);
    }

    @Override
    protected void processEvent(RelationEvent<?> rEvent) {
        ElementEvent.EventType eEventType;
        Object rValue;
        Relation rRelation = (Relation)rEvent.getElement();
        T rCollectValue = this.fCollector.evaluate(rRelation, rValue = (eEventType = rEvent.getType()) == ElementEvent.EventType.UPDATE ? rEvent.getUpdateValue() : rRelation.getTarget());
        if (rCollectValue != null) {
            Relation rCollectRelation = rEvent.getEventScope().getRelation(this);
            Collection rValues = (Collection)rCollectRelation.getTarget();
            if (rValues instanceof CollectionWrapper) {
                rValues = ((CollectionWrapper)rValues).rCollection;
            }
            if (eEventType == ElementEvent.EventType.ADD || eEventType == ElementEvent.EventType.UPDATE) {
                rValues.add(rCollectValue);
                if (rCollectRelation.hasRelation(StandardTypes.MAXIMUM)) {
                    int nMaxSize = rCollectRelation.getAnnotation(StandardTypes.MAXIMUM);
                    while (rValues.size() > nMaxSize) {
                        if (rValues instanceof List) {
                            ((List)rValues).remove(0);
                            continue;
                        }
                        rValues.remove(CollectionUtil.firstElementOf(rValues));
                    }
                }
            } else if (this.bDistinctValues && eEventType == ElementEvent.EventType.REMOVE) {
                rValues.remove(rCollectValue);
            }
        }
    }

    @Override
    protected void protectTarget(Relatable rParent, Relation<Collection<T>> rRelation) {
        this.setRelationTarget(rRelation, new CollectionWrapper<T>(rRelation.getTarget()));
    }

    private static class CollectionWrapper<E>
    extends ImmutableCollection<E> {
        private final Collection<E> rCollection;

        public CollectionWrapper(Collection<E> rWrappedCollection) {
            super(rWrappedCollection);
            this.rCollection = rWrappedCollection;
        }
    }
}

