/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.type;

import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.Functions;
import de.esoco.lib.expression.MathFunctions;
import de.esoco.lib.expression.Predicate;
import org.obrel.core.Relation;
import org.obrel.core.RelationEvent;
import org.obrel.core.RelationTypeModifier;
import org.obrel.type.AutomaticType;

public class CounterType<N extends Number>
extends AutomaticType<N> {
    private static final long serialVersionUID = 1L;
    private final Predicate<RelationEvent<?>> pCount;
    private final Function<N, N> fIncrement;

    public CounterType(String sName, N rInitialValue, Predicate<RelationEvent<?>> pCount, Function<N, N> fIncrement, RelationTypeModifier ... rModifiers) {
        super(sName, rInitialValue.getClass(), Functions.value(rInitialValue), rModifiers);
        this.pCount = pCount;
        this.fIncrement = fIncrement;
    }

    public static <N extends Number> CounterType<N> newCounter(N rInitialValue, Predicate<RelationEvent<?>> pCount, Function<N, N> fIncrement, RelationTypeModifier ... rModifiers) {
        return new CounterType<N>(null, rInitialValue, pCount, fIncrement, rModifiers);
    }

    public static CounterType<Integer> newIntCounter(Predicate<RelationEvent<?>> pCount, RelationTypeModifier ... rModifiers) {
        return CounterType.newCounter(0, pCount, MathFunctions.add(1), rModifiers);
    }

    @Override
    protected void processEvent(RelationEvent<?> rEvent) {
        if (this.pCount.test(rEvent)) {
            Relation rCount = rEvent.getEventScope().getRelation(this);
            this.setRelationTarget(rCount, (Number)this.fIncrement.apply((N)((Number)rCount.getTarget())));
        }
    }
}

