/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.application.converter;

import io.cloudevents.CloudEvent;
import java.util.Objects;
import java.util.stream.Stream;

public interface CloudEventConverter<T> {
    public CloudEvent toCloudEvent(T var1);

    public T toDomainEvent(CloudEvent var1);

    public String getCloudEventType(Class<? extends T> var1);

    default public String getCloudEventType(T event) {
        Objects.requireNonNull(event, "Domain event cannot be null");
        return this.getCloudEventType((T)event.getClass());
    }

    default public Stream<CloudEvent> toCloudEvents(Stream<T> events) {
        Stream<Object> stream = events == null ? Stream.empty() : events;
        return stream.map(this::toCloudEvent);
    }

    default public Stream<T> toDomainEvents(Stream<CloudEvent> events) {
        Stream<Object> stream = events == null ? Stream.empty() : events;
        return stream.map(this::toDomainEvent);
    }
}

