/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.cloudevents;

import io.cloudevents.CloudEventExtension;
import io.cloudevents.CloudEventExtensions;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class OccurrentCloudEventExtension
implements CloudEventExtension {
    public static final String STREAM_ID = "streamid";
    public static final String STREAM_VERSION = "streamversion";
    static final Set<String> KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("streamid", "streamversion")));
    private String streamId;
    private long streamVersion;

    public OccurrentCloudEventExtension(String streamId, long streamVersion) {
        Objects.requireNonNull(streamId, "StreamId cannot be null");
        if (streamVersion < 1L) {
            throw new IllegalArgumentException("Stream version cannot be less than 1");
        }
        this.streamId = streamId;
        this.streamVersion = streamVersion;
    }

    public static OccurrentCloudEventExtension occurrent(String streamId, long streamVersion) {
        return new OccurrentCloudEventExtension(streamId, streamVersion);
    }

    public void readFrom(CloudEventExtensions extensions) {
        Object streamVersion;
        Object streamId = extensions.getExtension(STREAM_ID);
        if (streamId != null) {
            this.streamId = streamId.toString();
        }
        if ((streamVersion = extensions.getExtension(STREAM_VERSION)) != null) {
            this.streamVersion = (Long)streamVersion;
        }
    }

    public Object getValue(String key) throws IllegalArgumentException {
        if (STREAM_ID.equals(key)) {
            return this.streamId;
        }
        if (STREAM_VERSION.equals(key)) {
            return this.streamVersion;
        }
        throw new IllegalArgumentException(this.getClass().getSimpleName() + " doesn't expect the attribute key \"" + key + "\"");
    }

    public Set<String> getKeys() {
        return KEYS;
    }
}

