/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.eventstore.api.blocking;

import io.cloudevents.CloudEvent;
import java.util.Objects;
import java.util.stream.Stream;
import org.occurrent.eventstore.api.WriteCondition;
import org.occurrent.eventstore.api.WriteResult;

public interface ConditionallyWriteToEventStream {
    default public WriteResult write(String streamId, long expectedStreamVersion, CloudEvent event) {
        Objects.requireNonNull(event, CloudEvent.class.getSimpleName() + " cannot be null");
        return this.write(streamId, WriteCondition.streamVersionEq((long)expectedStreamVersion), Stream.of(event));
    }

    default public WriteResult write(String streamId, WriteCondition writeCondition, CloudEvent event) {
        Objects.requireNonNull(event, CloudEvent.class.getSimpleName() + " cannot be null");
        return this.write(streamId, writeCondition, Stream.of(event));
    }

    default public WriteResult write(String streamId, long expectedStreamVersion, Stream<CloudEvent> events) {
        return this.write(streamId, WriteCondition.streamVersionEq((long)expectedStreamVersion), events);
    }

    public WriteResult write(String var1, WriteCondition var2, Stream<CloudEvent> var3);
}

