/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.eventstore.api.blocking;

import io.cloudevents.CloudEvent;
import java.util.Objects;
import java.util.stream.Stream;
import org.occurrent.eventstore.api.SortBy;
import org.occurrent.filter.Filter;

public interface EventStoreQueries {
    public Stream<CloudEvent> query(Filter var1, int var2, int var3, SortBy var4);

    public long count(Filter var1);

    default public long count() {
        return this.count(Filter.all());
    }

    public boolean exists(Filter var1);

    default public Stream<CloudEvent> query(Filter filter, SortBy sortBy) {
        return this.query(filter, 0, Integer.MAX_VALUE, sortBy);
    }

    default public Stream<CloudEvent> query(Filter filter, int skip, int limit) {
        return this.query(filter, skip, limit, (SortBy)SortBy.unsorted());
    }

    default public Stream<CloudEvent> all(int skip, int limit, SortBy sortBy) {
        return this.query(Filter.all(), skip, limit, sortBy);
    }

    default public Stream<CloudEvent> all(SortBy sortBy) {
        return this.query(Filter.all(), sortBy);
    }

    default public Stream<CloudEvent> all(int skip, int limit) {
        return this.query(Filter.all(), skip, limit);
    }

    default public Stream<CloudEvent> all() {
        return this.all(0, Integer.MAX_VALUE);
    }

    default public Stream<CloudEvent> query(Filter filter) {
        Objects.requireNonNull(filter, "Filter cannot be null");
        return this.query(filter, 0, Integer.MAX_VALUE);
    }
}

