/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.eventstore.api.blocking;

import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface EventStream<T>
extends Iterable<T> {
    public String id();

    public long version();

    public Stream<T> events();

    @Override
    default public Iterator<T> iterator() {
        return this.events().iterator();
    }

    default public boolean isEmpty() {
        return this.version() == 0L;
    }

    default public List<T> eventList() {
        return this.events().collect(Collectors.toList());
    }

    default public <T2> EventStream<T2> map(final Function<T, T2> fn) {
        return new EventStream<T2>(){

            @Override
            public Iterator<T2> iterator() {
                return this.events().iterator();
            }

            @Override
            public String id() {
                return EventStream.this.id();
            }

            @Override
            public long version() {
                return EventStream.this.version();
            }

            @Override
            public Stream<T2> events() {
                return EventStream.this.events().map(fn);
            }

            public String toString() {
                return "EventStream{id='" + this.id() + "', version=" + this.version() + ", events=" + this.events() + "}";
            }
        };
    }
}

