/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.eventstore.api;

import java.net.URI;
import java.util.Objects;
import java.util.StringJoiner;

public class DuplicateCloudEventException
extends RuntimeException {
    private final String id;
    private final URI source;
    private final String details;

    public DuplicateCloudEventException(String id, URI source) {
        this(id, source, null, null);
    }

    public DuplicateCloudEventException(String id, URI source, String details, Throwable cause) {
        super("Duplicate CloudEvent detected with id " + DuplicateCloudEventException.unknownIfNull(id) + " and source " + DuplicateCloudEventException.unknownIfNull(source == null ? null : source.toString()) + (String)(details == null ? "." : ", details: " + DuplicateCloudEventException.unknownIfNull(details)), cause);
        this.id = id;
        this.source = source;
        this.details = details;
    }

    public String getId() {
        return this.id;
    }

    public URI getSource() {
        return this.source;
    }

    public String getDetails() {
        return this.details;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DuplicateCloudEventException)) {
            return false;
        }
        DuplicateCloudEventException that = (DuplicateCloudEventException)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.source, that.source) && Objects.equals(this.details, that.details);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.source, this.details);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", DuplicateCloudEventException.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("source=" + this.source).add("details='" + this.details + "'").toString();
    }

    private static String unknownIfNull(String str) {
        return str == null ? "<unknown>" : str;
    }
}

