/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.eventstore.api;

import java.util.Objects;
import java.util.stream.Stream;
import org.occurrent.condition.Condition;

public class LongConditionEvaluator {
    public static boolean evaluate(Condition<Long> condition, long value) {
        Objects.requireNonNull(condition, "Condition cannot be null");
        if (condition instanceof Condition.MultiOperandCondition) {
            Condition.MultiOperandCondition operation = (Condition.MultiOperandCondition)condition;
            Condition.MultiOperandConditionName operationName = operation.operationName();
            Stream operations = operation.operations().stream();
            switch (operationName) {
                case AND: {
                    return operations.allMatch(c -> LongConditionEvaluator.evaluate((Condition<Long>)c, value));
                }
                case OR: {
                    return operations.anyMatch(c -> LongConditionEvaluator.evaluate((Condition<Long>)c, value));
                }
                case NOT: {
                    return operations.noneMatch(c -> LongConditionEvaluator.evaluate((Condition<Long>)c, value));
                }
            }
            throw new IllegalStateException("Unexpected value: " + operationName);
        }
        if (condition instanceof Condition.SingleOperandCondition) {
            Condition.SingleOperandCondition singleOperandCondition = (Condition.SingleOperandCondition)condition;
            long operand = (Long)singleOperandCondition.operand();
            Condition.SingleOperandConditionName singleOperandConditionName = singleOperandCondition.operandConditionName();
            switch (singleOperandConditionName) {
                case EQ: {
                    return value == operand;
                }
                case LT: {
                    return value < operand;
                }
                case GT: {
                    return value > operand;
                }
                case LTE: {
                    return value <= operand;
                }
                case GTE: {
                    return value >= operand;
                }
                case NE: {
                    return value != operand;
                }
            }
            throw new IllegalStateException("Unexpected value: " + singleOperandConditionName);
        }
        throw new IllegalArgumentException("Unsupported condition: " + condition.getClass());
    }
}

