/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.eventstore.api;

import java.util.Objects;
import org.occurrent.condition.Condition;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface WriteCondition {
    public static WriteCondition anyStreamVersion() {
        return StreamVersionWriteCondition.any();
    }

    public static WriteCondition streamVersionEq(long version) {
        return WriteCondition.streamVersion((Condition<Long>)Condition.eq((Object)version));
    }

    public static WriteCondition streamVersion(Condition<Long> condition) {
        return StreamVersionWriteCondition.streamVersion(condition);
    }

    default public boolean isAnyStreamVersion() {
        return this instanceof StreamVersionWriteCondition && ((StreamVersionWriteCondition)this).isAny();
    }

    public record StreamVersionWriteCondition(Condition<Long> condition) implements WriteCondition
    {
        public static StreamVersionWriteCondition streamVersion(Condition<Long> condition) {
            Objects.requireNonNull(condition, "Stream version condition cannot be null");
            return new StreamVersionWriteCondition(condition);
        }

        public static StreamVersionWriteCondition any() {
            return new StreamVersionWriteCondition(null);
        }

        @Override
        public String toString() {
            return this.condition == null ? "any" : this.condition.description();
        }

        public boolean isAny() {
            return this.condition == null;
        }
    }
}

