/*
 * Decompiled with CFR 0.152.
 */
package org.occurrent.subscription.inmemory;

import io.cloudevents.CloudEvent;
import java.time.Duration;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.occurrent.filter.Filter;
import org.occurrent.inmemory.filtermatching.FilterMatcher;
import org.occurrent.retry.RetryStrategy;
import org.occurrent.retry.internal.RetryExecution;
import org.occurrent.subscription.DurationToTimeoutConverter;
import org.occurrent.subscription.api.blocking.Subscription;

public class InMemorySubscription
implements Subscription,
Runnable {
    private final String id;
    private final BlockingQueue<CloudEvent> queue;
    private final Consumer<CloudEvent> consumer;
    private final Filter filter;
    private final RetryStrategy retryStrategy;
    private volatile boolean shutdown;
    private final CountDownLatch started = new CountDownLatch(1);

    InMemorySubscription(String id, BlockingQueue<CloudEvent> queue, Consumer<CloudEvent> consumer, Filter filter, RetryStrategy retryStrategy) {
        this.id = id;
        this.queue = queue;
        this.consumer = consumer;
        this.filter = filter;
        this.retryStrategy = retryStrategy;
        this.shutdown = false;
    }

    public String id() {
        return this.id;
    }

    public boolean waitUntilStarted(Duration timeout) {
        DurationToTimeoutConverter.Timeout safeTimeout = DurationToTimeoutConverter.convertDurationToTimeout((Duration)timeout);
        try {
            return this.started.await(safeTimeout.timeout(), safeTimeout.timeUnit());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InMemorySubscription)) {
            return false;
        }
        InMemorySubscription that = (InMemorySubscription)o;
        return this.shutdown == that.shutdown && Objects.equals(this.id, that.id) && Objects.equals(this.queue, that.queue) && Objects.equals(this.consumer, that.consumer) && Objects.equals(this.filter, that.filter) && Objects.equals(this.retryStrategy, that.retryStrategy);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.queue, this.consumer, this.filter, this.retryStrategy, this.shutdown);
    }

    public String toString() {
        return new StringJoiner(", ", InMemorySubscription.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("queue=" + this.queue).add("consumer=" + this.consumer).add("filter=" + this.filter).add("retryStrategy=" + this.retryStrategy).add("shutdown=" + this.shutdown).toString();
    }

    void eventAvailable(CloudEvent cloudEvent) {
        this.queue.offer(cloudEvent);
    }

    void shutdown() {
        this.shutdown = true;
    }

    boolean matches(CloudEvent cloudEvent) {
        return FilterMatcher.matchesFilter((CloudEvent)cloudEvent, (Filter)this.filter);
    }

    @Override
    public void run() {
        this.started.countDown();
        while (!this.shutdown) {
            CloudEvent cloudEvent;
            try {
                cloudEvent = this.queue.poll(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                continue;
            }
            if (cloudEvent == null) continue;
            RetryExecution.executeWithRetry(this.consumer, __ -> !this.shutdown, (RetryStrategy)this.retryStrategy).accept(cloudEvent);
        }
    }
}

