/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.component;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.Component;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.Date;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.DateList;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.DateTime;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.PropertyList;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.ValidationException;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.parameter.Value;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.property.DtStart;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.property.RDate;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.property.RRule;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.property.TzOffsetFrom;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.property.TzOffsetTo;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.util.Dates;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.util.PropertyValidator;
import org.ocpsoft.prettytime.shade.net.fortuna.ical4j.util.TimeZones;
import org.ocpsoft.prettytime.shade.org.apache.commons.logging.Log;
import org.ocpsoft.prettytime.shade.org.apache.commons.logging.LogFactory;

public abstract class Observance
extends Component
implements Comparable {
    private static final long serialVersionUID = 2523330383042085994L;
    public static final String STANDARD = "STANDARD";
    public static final String DAYLIGHT = "DAYLIGHT";
    private long[] onsetsMillisec;
    private DateTime[] onsetsDates;
    private Map onsets = new TreeMap();
    private Date initialOnset = null;
    private static final String UTC_PATTERN = "yyyyMMdd'T'HHmmss";
    private static final DateFormat UTC_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
    private Date onsetLimit;

    protected Observance(String name) {
        super(name);
    }

    protected Observance(String name, PropertyList properties) {
        super(name, properties);
    }

    public final void validate(boolean recurse) throws ValidationException {
        PropertyValidator.getInstance().assertOne("TZOFFSETFROM", this.getProperties());
        PropertyValidator.getInstance().assertOne("TZOFFSETTO", this.getProperties());
        PropertyValidator.getInstance().assertOne("DTSTART", this.getProperties());
        if (recurse) {
            this.validateProperties();
        }
    }

    public final Date getLatestOnset(Date date) {
        DateTime initialOnsetUTC;
        if (this.initialOnset == null) {
            try {
                this.initialOnset = this.applyOffsetFrom(this.calculateOnset(((DtStart)this.getProperty("DTSTART")).getDate()));
            }
            catch (ParseException e) {
                Log log = LogFactory.getLog(Observance.class);
                log.error("Unexpected error calculating initial onset", e);
                return null;
            }
        }
        if (date.before(this.initialOnset)) {
            return null;
        }
        if (this.onsetsMillisec != null && (this.onsetLimit == null || date.before(this.onsetLimit))) {
            return this.getCachedOnset(date);
        }
        Date onset = this.initialOnset;
        try {
            initialOnsetUTC = this.calculateOnset(((DtStart)this.getProperty("DTSTART")).getDate());
        }
        catch (ParseException e) {
            Log log = LogFactory.getLog(Observance.class);
            log.error("Unexpected error calculating initial onset", e);
            return null;
        }
        DateList cacheableOnsets = new DateList();
        cacheableOnsets.setUtc(true);
        cacheableOnsets.add(this.initialOnset);
        PropertyList rdates = this.getProperties("RDATE");
        Iterator i = rdates.iterator();
        while (i.hasNext()) {
            RDate rdate = (RDate)i.next();
            Iterator j = rdate.getDates().iterator();
            while (j.hasNext()) {
                try {
                    DateTime rdateOnset = this.applyOffsetFrom(this.calculateOnset((Date)j.next()));
                    if (!rdateOnset.after(date) && rdateOnset.after(onset)) {
                        onset = rdateOnset;
                    }
                    cacheableOnsets.add(rdateOnset);
                }
                catch (ParseException e) {
                    Log log = LogFactory.getLog(class$net$fortuna$ical4j$model$component$Observance == null ? Observance.class$("org.ocpsoft.prettytime.shade.net.fortuna.ical4j.model.component.Observance") : class$net$fortuna$ical4j$model$component$Observance);
                    log.error("Unexpected error calculating onset", e);
                }
            }
        }
        PropertyList rrules = this.getProperties("RRULE");
        Iterator i2 = rrules.iterator();
        while (i2.hasNext()) {
            RRule rrule = (RRule)i2.next();
            Calendar cal = Dates.getCalendarInstance(date);
            cal.setTime(date);
            cal.add(1, 10);
            this.onsetLimit = Dates.getInstance(cal.getTime(), Value.DATE_TIME);
            DateList recurrenceDates = rrule.getRecur().getDates((Date)initialOnsetUTC, this.onsetLimit, Value.DATE_TIME);
            Iterator j = recurrenceDates.iterator();
            while (j.hasNext()) {
                DateTime rruleOnset = this.applyOffsetFrom((DateTime)j.next());
                if (!rruleOnset.after(date) && rruleOnset.after(onset)) {
                    onset = rruleOnset;
                }
                cacheableOnsets.add(rruleOnset);
            }
        }
        Collections.sort(cacheableOnsets);
        DateTime cacheableOnset = null;
        this.onsetsMillisec = new long[cacheableOnsets.size()];
        this.onsetsDates = new DateTime[this.onsetsMillisec.length];
        for (int i3 = 0; i3 < this.onsetsMillisec.length; ++i3) {
            cacheableOnset = (DateTime)cacheableOnsets.get(i3);
            this.onsetsMillisec[i3] = cacheableOnset.getTime();
            this.onsetsDates[i3] = cacheableOnset;
        }
        return onset;
    }

    private DateTime getCachedOnset(Date date) {
        int index = Arrays.binarySearch(this.onsetsMillisec, date.getTime());
        if (index >= 0) {
            return this.onsetsDates[index];
        }
        int insertionIndex = -index - 1;
        return this.onsetsDates[insertionIndex - 1];
    }

    public final DtStart getStartDate() {
        return (DtStart)this.getProperty("DTSTART");
    }

    public final TzOffsetFrom getOffsetFrom() {
        return (TzOffsetFrom)this.getProperty("TZOFFSETFROM");
    }

    public final TzOffsetTo getOffsetTo() {
        return (TzOffsetTo)this.getProperty("TZOFFSETTO");
    }

    public final int compareTo(Object arg0) {
        return this.compareTo((Observance)arg0);
    }

    public final int compareTo(Observance arg0) {
        DtStart dtStart = (DtStart)this.getProperty("DTSTART");
        DtStart dtStart0 = (DtStart)arg0.getProperty("DTSTART");
        return dtStart.getDate().compareTo(dtStart0.getDate());
    }

    private DateTime calculateOnset(Date date) throws ParseException {
        return this.calculateOnset(date.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DateTime calculateOnset(String dateStr) throws ParseException {
        long utcOnset;
        DateFormat dateFormat = UTC_FORMAT;
        synchronized (dateFormat) {
            utcOnset = UTC_FORMAT.parse(dateStr).getTime();
        }
        DateTime onset = new DateTime(true);
        onset.setTime(utcOnset);
        return onset;
    }

    private DateTime applyOffsetFrom(DateTime orig) {
        DateTime withOffset = new DateTime(true);
        withOffset.setTime(orig.getTime() - this.getOffsetFrom().getOffset().getOffset());
        return withOffset;
    }

    static {
        UTC_FORMAT.setTimeZone(TimeZones.getUtcTimeZone());
        UTC_FORMAT.setLenient(false);
    }
}

