/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ocpsoft.common.pattern.WeightedComparator;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.bind.Evaluation;
import org.ocpsoft.rewrite.config.ConditionVisit;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.ConfigurationProvider;
import org.ocpsoft.rewrite.config.OperationVisit;
import org.ocpsoft.rewrite.config.ParameterizedCallback;
import org.ocpsoft.rewrite.config.ParameterizedConditionVisitor;
import org.ocpsoft.rewrite.config.ParameterizedOperationVisitor;
import org.ocpsoft.rewrite.config.RelocatableRule;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.param.ConfigurableParameter;
import org.ocpsoft.rewrite.param.DefaultParameter;
import org.ocpsoft.rewrite.param.Parameter;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;
import org.ocpsoft.rewrite.param.ParameterizedRule;
import org.ocpsoft.rewrite.spi.ConfigurationCacheProvider;

public class ConfigurationLoader {
    public static Logger log = Logger.getLogger(ConfigurationLoader.class);
    private final List<ConfigurationCacheProvider<?>> caches = Iterators.asList((Iterable)ServiceLoader.load(ConfigurationCacheProvider.class));
    private final List<ConfigurationProvider<?>> providers;

    public ConfigurationLoader(Object context) {
        Collections.sort(this.caches, new WeightedComparator());
        this.providers = Iterators.asList((Iterable)ServiceLoader.load(ConfigurationProvider.class));
        Collections.sort(this.providers, new WeightedComparator());
    }

    public static ConfigurationLoader create(Object context) {
        return new ConfigurationLoader(context);
    }

    public Configuration loadConfiguration(Object context) {
        if (this.caches.isEmpty()) {
            return this.build(context);
        }
        return this.buildCached(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Configuration buildCached(Object context) {
        Configuration result = null;
        for (ConfigurationCacheProvider<?> cache : this.caches) {
            Configuration cachedConfig = cache.getConfiguration(context);
            if (cachedConfig == null) continue;
            result = cachedConfig;
            break;
        }
        if (result == null) {
            ConfigurationLoader configurationLoader = this;
            synchronized (configurationLoader) {
                for (ConfigurationCacheProvider<?> cache : this.caches) {
                    Configuration cachedConfig = cache.getConfiguration(context);
                    if (cachedConfig == null) continue;
                    result = cachedConfig;
                    break;
                }
                if (result == null) {
                    result = this.build(context);
                    for (ConfigurationCacheProvider<?> cache : this.caches) {
                        cache.setConfiguration(context, result);
                    }
                }
            }
        }
        return result;
    }

    private Configuration build(Object context) {
        LinkedHashMap priorityMap = new LinkedHashMap();
        for (ConfigurationProvider<?> provider : this.providers) {
            if (!provider.handles(context)) continue;
            Configuration configuration = provider.getConfiguration(context);
            if (configuration != null) {
                List<Rule> rules = configuration.getRules();
                if (rules != null) {
                    for (Rule rule : rules) {
                        if (rule != null) {
                            if (rule instanceof RelocatableRule && ((RelocatableRule)rule).isRelocated()) {
                                ConfigurationLoader.addListValue(priorityMap, ((RelocatableRule)rule).priority(), rule);
                                continue;
                            }
                            ConfigurationLoader.addListValue(priorityMap, provider.priority(), rule);
                            continue;
                        }
                        log.debug("Ignoring null Rule from ConfigurationProvider [" + provider.getClass().getName() + "]");
                    }
                    continue;
                }
                log.debug("Ignoring null List<Rule> from ConfigurationProvider [" + provider.getClass().getName() + "]");
                continue;
            }
            log.debug("Ignoring null Configuration from ConfigurationProvider [" + provider.getClass().getName() + "].");
        }
        ConfigurationBuilder result = ConfigurationBuilder.begin();
        ArrayList sortedKeys = new ArrayList(priorityMap.keySet());
        Collections.sort(sortedKeys);
        for (Integer integer : sortedKeys) {
            List list = (List)priorityMap.get(integer);
            for (final Rule rule : list) {
                result.addRule(rule);
                if (!(rule instanceof ParameterizedRule)) continue;
                ParameterizedCallback callback = new ParameterizedCallback(){

                    @Override
                    public void call(Parameterized parameterized) {
                        Set<String> names = parameterized.getRequiredParameterNames();
                        ParameterStore store = ((ParameterizedRule)rule).getParameterStore();
                        if (names != null) {
                            for (String name : names) {
                                Parameter<?> parameter = store.get(name, new DefaultParameter(name));
                                if (!(parameter instanceof ConfigurableParameter)) continue;
                                ((ConfigurableParameter)parameter).bindsTo(Evaluation.property(name));
                            }
                        }
                        parameterized.setParameterStore(store);
                    }
                };
                ParameterizedConditionVisitor conditionVisitor = new ParameterizedConditionVisitor(callback);
                new ConditionVisit(rule).accept(conditionVisitor);
                ParameterizedOperationVisitor operationVisitor = new ParameterizedOperationVisitor(callback);
                new OperationVisit(rule).accept(operationVisitor);
            }
        }
        return result;
    }

    public static <K, T> void addListValue(Map<K, List<T>> map, K key, T value) {
        if (!map.containsKey(key)) {
            map.put(key, new ArrayList<Object>(Arrays.asList(value)));
        } else {
            map.get(key).add(value);
        }
    }
}

