/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.rewrite;

import com.ocpsoft.pretty.faces.config.rewrite.RewriteRule;
import com.ocpsoft.pretty.faces.rewrite.Processor;
import com.ocpsoft.pretty.faces.rewrite.processor.CaseProcessor;
import com.ocpsoft.pretty.faces.rewrite.processor.CustomClassProcessor;
import com.ocpsoft.pretty.faces.rewrite.processor.RegexProcessor;
import com.ocpsoft.pretty.faces.rewrite.processor.TrailingSlashProcessor;
import com.ocpsoft.pretty.faces.rewrite.processor.UrlProcessor;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RewriteEngine {
    private static List<Processor> processors;

    public String processInbound(HttpServletRequest request, HttpServletResponse response, RewriteRule rule, String url) {
        String result = url;
        if (rule != null && rule.isInbound() && rule.matches(url)) {
            for (Processor p : processors) {
                result = p.processInbound(request, response, rule, result);
            }
        }
        return result;
    }

    public String processOutbound(HttpServletRequest request, HttpServletResponse response, RewriteRule rule, String url) {
        String result = url;
        if (rule != null && rule.isOutbound() && rule.matches(url)) {
            for (Processor p : processors) {
                result = p.processOutbound(request, response, rule, result);
            }
        }
        return result;
    }

    static {
        ArrayList<Processor> list = new ArrayList<Processor>();
        list.add(new RegexProcessor());
        list.add(new CaseProcessor());
        list.add(new TrailingSlashProcessor());
        list.add(new CustomClassProcessor());
        list.add(new UrlProcessor());
        processors = Collections.unmodifiableList(list);
    }
}

