/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.util;

import jakarta.faces.application.FacesMessage;
import jakarta.faces.context.FacesContext;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;

public class FacesMessagesUtils {
    protected static final String token = "com.ocpsoft.pretty.SAVED_FACES_MESSAGES";

    public int saveMessages(FacesContext facesContext, Map<String, Object> destination) {
        int savedCount = 0;
        if (facesContext != null) {
            LinkedHashSet<FacesMessageWrapper> messages = new LinkedHashSet<FacesMessageWrapper>();
            Iterator iter = facesContext.getMessages(null);
            while (iter.hasNext()) {
                messages.add(new FacesMessageWrapper((FacesMessage)iter.next()));
            }
            if (messages.size() > 0) {
                LinkedHashSet existingMessages = (LinkedHashSet)destination.get(token);
                if (existingMessages != null) {
                    existingMessages.addAll(messages);
                } else {
                    destination.put(token, messages);
                }
                savedCount = messages.size();
            }
        }
        return savedCount;
    }

    public int restoreMessages(FacesContext facesContext, Map<String, Object> source) {
        int restoredCount = 0;
        if (facesContext != null) {
            LinkedHashSet messages = (LinkedHashSet)source.remove(token);
            if (messages == null) {
                return 0;
            }
            LinkedHashSet<FacesMessageWrapper> exitingMessages = new LinkedHashSet<FacesMessageWrapper>();
            Iterator iter = facesContext.getMessages(null);
            while (iter.hasNext()) {
                exitingMessages.add(new FacesMessageWrapper((FacesMessage)iter.next()));
            }
            for (FacesMessageWrapper message : messages) {
                if (exitingMessages.contains(message)) continue;
                facesContext.addMessage(null, message.getWrapped());
                ++restoredCount;
            }
        }
        return restoredCount;
    }

    private static class FacesMessageWrapper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final FacesMessage wrapped;

        public FacesMessageWrapper(FacesMessage wrapped) {
            this.wrapped = wrapped;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.wrapped.getSeverity() == null ? 0 : this.wrapped.getSeverity().hashCode());
            result = 31 * result + (this.wrapped.getSummary() == null ? 0 : this.wrapped.getSummary().hashCode());
            result = 31 * result + (this.wrapped.getDetail() == null ? 0 : this.wrapped.getDetail().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FacesMessageWrapper other = (FacesMessageWrapper)obj;
            if (this.wrapped.getSeverity() == null ? other.wrapped.getSeverity() != null : !this.wrapped.getSeverity().equals(other.wrapped.getSeverity())) {
                return false;
            }
            if (this.wrapped.getSummary() == null ? other.wrapped.getSummary() != null : !this.wrapped.getSummary().equals(other.wrapped.getSummary())) {
                return false;
            }
            return !(this.wrapped.getDetail() == null ? other.wrapped.getDetail() != null : !this.wrapped.getDetail().equals(other.wrapped.getDetail()));
        }

        public FacesMessage getWrapped() {
            return this.wrapped;
        }
    }
}

