/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.beans;

import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.config.mapping.PathParameter;
import com.ocpsoft.pretty.faces.config.mapping.QueryParameter;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.url.QueryString;
import com.ocpsoft.pretty.faces.url.URL;
import com.ocpsoft.pretty.faces.url.URLPatternParser;
import com.ocpsoft.pretty.faces.util.FacesElUtils;
import com.ocpsoft.pretty.faces.util.NullComponent;
import jakarta.el.ELException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import java.util.ArrayList;
import java.util.List;

public class ExtractedValuesURLBuilder {
    private static final FacesElUtils elUtils = new FacesElUtils();

    public URL buildURL(UrlMapping mapping) {
        URL result = null;
        String expression = "";
        Object value = null;
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            URLPatternParser parser = mapping.getPatternParser();
            List<PathParameter> parameters = parser.getPathParameters();
            ArrayList<String> parameterValues = new ArrayList<String>();
            for (PathParameter injection : parameters) {
                expression = injection.getExpression().getELExpression();
                value = elUtils.getValue(context, expression);
                if (value == null) {
                    throw new PrettyException("PrettyFaces: Exception occurred while building URL for MappingId < " + mapping.getId() + " >, Required value  < " + expression + " > was null");
                }
                Converter converter = context.getApplication().createConverter(value.getClass());
                if (converter != null) {
                    String convertedValue = converter.getAsString(context, (UIComponent)new NullComponent(), value);
                    if (convertedValue == null) {
                        throw new PrettyException("PrettyFaces: The converter <" + converter.getClass().getName() + "> returned null while converting the object <" + value.toString() + ">!");
                    }
                    value = convertedValue;
                }
                parameterValues.add(value.toString());
            }
            result = parser.getMappedURL(parameterValues).encode();
        }
        catch (ELException e) {
            throw new PrettyException("PrettyFaces: Exception occurred while building URL for MappingId < " + mapping.getId() + " >, Error occurred while extracting values from backing bean < " + expression + ":" + value + " >", e);
        }
        return result;
    }

    public QueryString buildQueryString(UrlMapping mapping) {
        QueryString result = new QueryString();
        String expression = "";
        Object value = null;
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            List<QueryParameter> queryParams = mapping.getQueryParams();
            ArrayList<QueryParameter> queryParameterValues = new ArrayList<QueryParameter>();
            for (QueryParameter injection : queryParams) {
                String name = injection.getName();
                expression = injection.getExpression().getELExpression();
                value = elUtils.getValue(context, expression);
                if (name == null || value == null) continue;
                if (value.getClass().isArray()) {
                    Object[] values;
                    for (Object temp : values = (Object[])value) {
                        queryParameterValues.add(new QueryParameter(name, temp.toString()));
                    }
                    continue;
                }
                queryParameterValues.add(new QueryParameter(name, value.toString()));
            }
            result = QueryString.build(queryParameterValues);
        }
        catch (ELException e) {
            throw new PrettyException("PrettyFaces: Exception occurred while building QueryString for MappingId < " + mapping.getId() + " >, Error occurred while extracting values from backing bean < " + expression + ":" + value + " >", e);
        }
        return result;
    }
}

