/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.prettyfaces;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.mapping.PathParameter;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.url.QueryString;
import com.ocpsoft.pretty.faces.url.URL;
import com.ocpsoft.pretty.faces.util.PrettyURLBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIParameter;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.prettyfaces.PFUtil;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.urlbuilder.Address;
import org.ocpsoft.urlbuilder.AddressBuilder;

public class UrlMappingRuleAdaptor
implements Rule {
    public static final String REWRITE_MAPPING_ID_KEY = "com.ocpsoft.mappingId";
    private static Logger log = Logger.getLogger(UrlMappingRuleAdaptor.class);
    private final UrlMapping mapping;

    public UrlMappingRuleAdaptor(UrlMapping mapping) {
        this.mapping = mapping;
    }

    private String rewritePrettyMappings(PrettyConfig config, String contextPath, String url) {
        String result = url;
        if (url != null) {
            UIParameter uip;
            ArrayList<UIParameter> uiParams = new ArrayList<UIParameter>();
            QueryString qs = QueryString.build("");
            if (url.contains("?")) {
                qs.addParameters(url);
                qs.removeParameter(REWRITE_MAPPING_ID_KEY);
            }
            Map<String, String[]> queryParams = qs.getParameterMap();
            List<PathParameter> pathParams = this.mapping.getPatternParser().getPathParameters();
            int pathParamsFound = 0;
            for (PathParameter pathParameter : pathParams) {
                uip = new UIParameter();
                String[] values = queryParams.get(pathParameter.getName());
                if (values != null && values.length > 0) {
                    String value = values[0];
                    uip.setValue((Object)value);
                    if (value != null && !"".equals(value)) {
                        ++pathParamsFound;
                    }
                }
                queryParams.remove(pathParameter.getName());
                uiParams.add(uip);
            }
            for (Map.Entry entry : queryParams.entrySet()) {
                uip = new UIParameter();
                uip.setName((String)entry.getKey());
                uip.setValue(entry.getValue());
                uiParams.add(uip);
            }
            if (pathParams.size() == pathParamsFound) {
                PrettyURLBuilder builder = new PrettyURLBuilder();
                result = contextPath + builder.build(this.mapping, true, uiParams);
            }
        }
        return result;
    }

    public String getId() {
        return this.toString();
    }

    public boolean evaluate(Rewrite event, EvaluationContext ec) {
        PrettyContext context = PrettyContext.getCurrentInstance((HttpServletRequest)((HttpServletRewrite)event).getRequest());
        if (event instanceof HttpInboundServletRewrite && PFUtil.isMappingEnabled(event) && this.mapping.matches(context.getRequestURL())) {
            return true;
        }
        if (event instanceof HttpOutboundServletRewrite && this.mapping.isOutbound()) {
            QueryString queryString;
            String mappingId;
            String outboundURL = ((Address)((HttpOutboundServletRewrite)event).getOutboundAddress()).toString();
            if (outboundURL.startsWith(((HttpServletRewrite)event).getContextPath())) {
                outboundURL = outboundURL.substring(((HttpServletRewrite)event).getContextPath().length());
            }
            if ((mappingId = (queryString = QueryString.build(outboundURL)).getParameter(REWRITE_MAPPING_ID_KEY)) == null && outboundURL.startsWith(this.mapping.getViewId()) || this.mapping.getId().equals(mappingId)) {
                return true;
            }
        }
        return false;
    }

    public void perform(Rewrite event, EvaluationContext ec) {
        PrettyContext context = PrettyContext.getCurrentInstance((HttpServletRequest)((HttpServletRewrite)event).getRequest());
        if (event instanceof HttpInboundServletRewrite) {
            ((HttpServletRequest)((HttpServletRewrite)event).getRequest()).setAttribute(REWRITE_MAPPING_ID_KEY, (Object)("com.ocpsoft.mappingId:" + this.mapping.getId()));
            URL url = context.getRequestURL();
            if (context.shouldProcessDynaview()) {
                log.trace("Forwarding mapped request [" + url.toURL() + "] to dynaviewId [" + context.getDynaViewId() + "]");
                ((HttpInboundServletRewrite)event).forward(context.getDynaViewId());
            } else {
                String viewId = this.mapping.getViewId();
                log.trace("Forwarding mapped request [" + url.toURL() + "] to resource [" + viewId + "]");
                if (url.decode().toURL().equals(viewId)) {
                    ((HttpServletRewrite)event).proceed();
                } else {
                    ((HttpInboundServletRewrite)event).forward(viewId);
                }
            }
        } else if (event instanceof HttpOutboundServletRewrite && this.mapping.isOutbound()) {
            HttpOutboundServletRewrite outboundRewrite = (HttpOutboundServletRewrite)event;
            String newUrl = this.rewritePrettyMappings(context.getConfig(), ((HttpServletRewrite)event).getContextPath(), ((Address)outboundRewrite.getOutboundAddress()).toString());
            outboundRewrite.setOutboundAddress(AddressBuilder.create((String)newUrl));
        }
    }

    public String toString() {
        return "UrlMappingRuleAdaptor [mapping=" + this.mapping + "]";
    }
}

