/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config.servlet;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import org.ocpsoft.common.pattern.WeightedComparator;
import org.ocpsoft.common.services.ServiceLoader;
import org.ocpsoft.common.util.Iterators;
import org.ocpsoft.rewrite.servlet.ServletRegistration;
import org.ocpsoft.rewrite.servlet.spi.ServletRegistrationProvider;
import org.ocpsoft.shade.org.apache.commons.logging.Log;
import org.ocpsoft.shade.org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class WebXmlParser {
    private static final Log log = LogFactory.getLog(WebXmlParser.class);
    private static final String FACES_SERVLET = "javax.faces.webapp.FacesServlet";
    private String facesMapping = null;

    public void parse(ServletContext context) throws IOException, SAXException {
        List providers = Iterators.asList((Iterator)ServiceLoader.loadTypesafe(ServletRegistrationProvider.class).iterator());
        Collections.sort(providers, new WeightedComparator());
        for (ServletRegistrationProvider provider : providers) {
            List registrations = provider.getServletRegistrations(context);
            if (registrations == null) continue;
            for (ServletRegistration s : registrations) {
                List mappings;
                if (!s.getClassName().equalsIgnoreCase(FACES_SERVLET) || (mappings = s.getMappings()).isEmpty()) continue;
                this.facesMapping = (String)mappings.iterator().next();
                break;
            }
            if (this.facesMapping != null) continue;
            log.warn("Faces Servlet (javax.faces.webapp.FacesServlet) not found in web context - cannot configure PrettyFaces DynaView");
        }
    }

    public boolean isFacesPresent() {
        return this.facesMapping != null;
    }

    public String getFacesMapping() {
        if (this.isFacesPresent()) {
            return this.facesMapping;
        }
        return "";
    }
}

