/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config.dynaview;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.application.PrettyRedirector;
import com.ocpsoft.pretty.faces.beans.ExtractedValuesURLBuilder;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.util.FacesElUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.context.FacesContext;
import org.ocpsoft.shade.org.apache.commons.logging.Log;
import org.ocpsoft.shade.org.apache.commons.logging.LogFactory;

public class DynaviewEngine {
    public static final String DYNAVIEW = "com.ocpsoft.dynaView";
    private static final Log log = LogFactory.getLog(DynaviewEngine.class);
    private static FacesElUtils elUtils = new FacesElUtils();

    public String buildDynaViewId(String facesServletMapping) {
        StringBuffer result = new StringBuffer();
        HashMap<Pattern, String> patterns = new HashMap<Pattern, String>();
        Pattern pathMapping = Pattern.compile("^(/.*/)\\*$");
        Pattern extensionMapping = Pattern.compile("^\\*(\\..*)$");
        Pattern defaultMapping = Pattern.compile("^/$");
        patterns.put(pathMapping, "$1com.ocpsoft.dynaView.jsf");
        patterns.put(extensionMapping, "/com.ocpsoft.dynaView$1");
        patterns.put(defaultMapping, "/com.ocpsoft.dynaView.jsf");
        boolean matched = false;
        Iterator iterator = patterns.keySet().iterator();
        while (!matched && iterator.hasNext()) {
            Pattern p = (Pattern)iterator.next();
            Matcher m = p.matcher(facesServletMapping);
            if (!m.matches()) continue;
            String replacement = (String)patterns.get(p);
            m.appendReplacement(result, replacement);
            matched = true;
        }
        if (!matched) {
            result.append(facesServletMapping);
        }
        return result.toString();
    }

    public void processDynaView(PrettyContext prettyContext, FacesContext facesContext) {
        log.trace("Requesting DynaView processing for: " + prettyContext.getRequestURL());
        String viewId = "";
        try {
            viewId = prettyContext.getCurrentViewId();
            log.trace("Invoking DynaView method: " + viewId);
            String result = this.computeDynaViewId(facesContext);
            if (result instanceof String) {
                viewId = result;
                log.trace("Forwarding to DynaView: " + viewId);
                prettyContext.setDynaviewProcessed(true);
                facesContext.getExternalContext().dispatch(viewId);
                facesContext.responseComplete();
            }
        }
        catch (Exception e) {
            log.error("Failed to process dynaview", e);
            PrettyRedirector prettyRedirector = new PrettyRedirector();
            prettyRedirector.send404(facesContext);
            throw new PrettyException("Could not forward to view: " + viewId + "", e);
        }
    }

    public String computeDynaViewId(FacesContext facesContext) {
        PrettyContext context = PrettyContext.getCurrentInstance(facesContext);
        UrlMapping urlMapping = context.getCurrentMapping();
        return this.calculateDynaviewId(facesContext, urlMapping);
    }

    public String calculateDynaviewId(FacesContext facesContext, UrlMapping urlMapping) {
        String result = "";
        if (urlMapping != null) {
            PrettyContext context = PrettyContext.getCurrentInstance(facesContext);
            String viewId = urlMapping.getViewId();
            if (viewId == null) {
                viewId = "";
            }
            while (elUtils.isEl(viewId)) {
                Object viewResult = elUtils.invokeMethod(facesContext, viewId);
                if (viewResult == null) {
                    viewId = "";
                    break;
                }
                viewId = viewResult.toString();
                if (context.getConfig().isMappingId(viewId)) {
                    urlMapping = context.getConfig().getMappingById(viewId);
                    viewId = urlMapping.getViewId();
                    ExtractedValuesURLBuilder builder = new ExtractedValuesURLBuilder();
                    result = context.getContextPath() + builder.buildURL(urlMapping).encode() + builder.buildQueryString(urlMapping);
                    continue;
                }
                result = viewId;
            }
            if ("".equals(viewId)) {
                log.debug("ViewId for mapping with id <" + urlMapping.getId() + "> was blank");
            }
            result = context.stripContextPath(result);
        }
        return result;
    }
}

