/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.prettyfaces;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.mapping.PathParameter;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.url.QueryString;
import com.ocpsoft.pretty.faces.url.URL;
import com.ocpsoft.pretty.faces.util.PrettyURLBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIParameter;
import javax.servlet.http.HttpServletRequest;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.prettyfaces.PFUtil;
import org.ocpsoft.rewrite.servlet.http.event.HttpInboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.urlbuilder.Address;
import org.ocpsoft.urlbuilder.AddressBuilder;
import org.ocpsoft.urlbuilder.util.Decoder;

public class UrlMappingRuleAdaptor
implements Rule {
    public static final String REWRITE_MAPPING_ID_KEY = "com.ocpsoft.mappingId";
    private static Logger log = Logger.getLogger(UrlMappingRuleAdaptor.class);
    private final UrlMapping mapping;

    public UrlMappingRuleAdaptor(UrlMapping mapping) {
        this.mapping = mapping;
    }

    private String rewritePrettyMappings(PrettyConfig config, String contextPath, String url) {
        String result = url;
        if (url != null) {
            UIParameter uip;
            ArrayList<UIParameter> uiParams = new ArrayList<UIParameter>();
            QueryString qs = QueryString.build("");
            if (url.contains("?")) {
                qs.addParameters(url);
                QueryString mappingViewQueryString = QueryString.build(this.mapping.getViewId());
                for (String mappingViewParam : mappingViewQueryString.getParameterMap().keySet()) {
                    qs.removeParameter(mappingViewParam);
                }
                qs.removeParameter(REWRITE_MAPPING_ID_KEY);
            }
            Map<String, String[]> queryParams = qs.getParameterMap();
            List<PathParameter> pathParams = this.mapping.getPatternParser().getPathParameters();
            int pathParamsFound = 0;
            for (PathParameter pathParameter : pathParams) {
                uip = new UIParameter();
                String[] values = queryParams.get(pathParameter.getName());
                if (values != null && values.length > 0) {
                    String value = values[0];
                    uip.setValue((Object)value);
                    if (value != null && !"".equals(value)) {
                        ++pathParamsFound;
                    }
                }
                queryParams.remove(pathParameter.getName());
                uiParams.add(uip);
            }
            for (Map.Entry entry : queryParams.entrySet()) {
                uip = new UIParameter();
                uip.setName((String)entry.getKey());
                uip.setValue(entry.getValue());
                uiParams.add(uip);
            }
            if (pathParams.size() == pathParamsFound) {
                PrettyURLBuilder builder = new PrettyURLBuilder();
                result = contextPath + builder.build(this.mapping, true, uiParams);
            }
        }
        return result;
    }

    private boolean evaluateOutbound(String outboundURL) {
        int mappingViewQueryStringStart;
        String cachedMappingId;
        QueryString outboundQueryString = new QueryString();
        if (outboundURL.contains("?")) {
            outboundQueryString.addParameters(outboundURL);
        }
        if ((cachedMappingId = outboundQueryString.getParameter(REWRITE_MAPPING_ID_KEY)) != null) {
            return this.mapping.getId().equals(Decoder.query((CharSequence)cachedMappingId));
        }
        String outboundPath = outboundURL;
        String mappingViewId = this.mapping.getViewId();
        int outboundQueryStringStart = outboundPath.indexOf("?");
        if (outboundQueryStringStart != -1) {
            outboundPath = outboundPath.substring(0, outboundQueryStringStart);
        }
        if ((mappingViewQueryStringStart = mappingViewId.indexOf("?")) != -1) {
            mappingViewId = mappingViewId.substring(0, mappingViewQueryStringStart);
        }
        if (!mappingViewId.equals(outboundPath)) {
            return false;
        }
        QueryString mappingViewQueryString = new QueryString();
        if (this.mapping.getViewId().contains("?")) {
            mappingViewQueryString.addParameters(this.mapping.getViewId());
        }
        for (Map.Entry<String, String[]> mappingViewParam : mappingViewQueryString.getParameterMap().entrySet()) {
            for (String mappingViewParamValue : mappingViewParam.getValue()) {
                boolean found = false;
                block2: for (Map.Entry<String, String[]> outboundParam : outboundQueryString.getParameterMap().entrySet()) {
                    if (!mappingViewParam.getKey().equals(outboundParam.getKey())) continue;
                    for (String outboundParamValue : outboundParam.getValue()) {
                        if (mappingViewParamValue != outboundParamValue && (mappingViewParamValue == null || !mappingViewParamValue.equals(outboundParamValue))) continue;
                        found = true;
                        continue block2;
                    }
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public String getId() {
        return this.toString();
    }

    public boolean evaluate(Rewrite event, EvaluationContext ec) {
        PrettyContext context = PrettyContext.getCurrentInstance((HttpServletRequest)((HttpServletRewrite)event).getRequest());
        if (event instanceof HttpInboundServletRewrite && PFUtil.isMappingEnabled(event) && this.mapping.matches(context.getRequestURL())) {
            return true;
        }
        if (event instanceof HttpOutboundServletRewrite && this.mapping.isOutbound()) {
            String outboundURL = ((Address)((HttpOutboundServletRewrite)event).getOutboundAddress()).toString();
            if (outboundURL.startsWith(((HttpServletRewrite)event).getContextPath())) {
                outboundURL = outboundURL.substring(((HttpServletRewrite)event).getContextPath().length());
            }
            return this.evaluateOutbound(outboundURL);
        }
        return false;
    }

    public void perform(Rewrite event, EvaluationContext ec) {
        PrettyContext context = PrettyContext.getCurrentInstance((HttpServletRequest)((HttpServletRewrite)event).getRequest());
        if (event instanceof HttpInboundServletRewrite) {
            ((HttpServletRequest)((HttpServletRewrite)event).getRequest()).setAttribute(REWRITE_MAPPING_ID_KEY, (Object)("com.ocpsoft.mappingId:" + this.mapping.getId()));
            URL url = context.getRequestURL();
            if (context.shouldProcessDynaview()) {
                log.trace("Forwarding mapped request [" + url.toURL() + "] to dynaviewId [" + context.getDynaViewId() + "]");
                ((HttpInboundServletRewrite)event).forward(context.getDynaViewId());
            } else {
                String viewId = this.mapping.getViewId();
                log.trace("Forwarding mapped request [" + url.toURL() + "] to resource [" + viewId + "]");
                if (url.decode().toURL().equals(viewId)) {
                    ((HttpServletRewrite)event).proceed();
                } else {
                    ((HttpInboundServletRewrite)event).forward(viewId);
                }
            }
        } else if (event instanceof HttpOutboundServletRewrite && this.mapping.isOutbound()) {
            HttpOutboundServletRewrite outboundRewrite = (HttpOutboundServletRewrite)event;
            String newUrl = this.rewritePrettyMappings(context.getConfig(), ((HttpServletRewrite)event).getContextPath(), ((Address)outboundRewrite.getOutboundAddress()).toString());
            outboundRewrite.setOutboundAddress(AddressBuilder.create((String)newUrl));
        }
    }

    public String toString() {
        return "UrlMappingRuleAdaptor [mapping=" + this.mapping + "]";
    }
}

