/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.application;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.beans.ExtractedValuesURLBuilder;
import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.url.QueryString;
import com.ocpsoft.pretty.faces.url.URL;
import java.io.IOException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.ocpsoft.shade.org.apache.commons.logging.Log;
import org.ocpsoft.shade.org.apache.commons.logging.LogFactory;

public class PrettyRedirector {
    private static final Log log = LogFactory.getLog(PrettyRedirector.class);
    private final ExtractedValuesURLBuilder builder = new ExtractedValuesURLBuilder();

    public static PrettyRedirector getInstance() {
        return new PrettyRedirector();
    }

    public boolean redirect(FacesContext context, String action) {
        try {
            PrettyContext prettyContext = PrettyContext.getCurrentInstance(context);
            PrettyConfig config = prettyContext.getConfig();
            ExternalContext externalContext = context.getExternalContext();
            String contextPath = prettyContext.getContextPath();
            if ("pretty:".equals(action) && prettyContext.isPrettyRequest()) {
                URL url = prettyContext.getRequestURL();
                QueryString query = prettyContext.getRequestQueryString();
                String target = contextPath + url.encode() + query.toQueryString();
                log.trace("Refreshing requested page [" + url + "]");
                this.encodeURL(externalContext, config, target);
                return true;
            }
            if (this.isPrettyNavigationCase(prettyContext, action)) {
                UrlMapping mapping = config.getMappingById(action);
                if (mapping == null) {
                    throw new PrettyException("PrettyFaces: Invalid mapping id supplied to navigation handler: " + action);
                }
                String target = contextPath + this.builder.buildURL(mapping).encode() + this.builder.buildQueryString(mapping);
                log.trace("Redirecting to mappingId [" + mapping.getId() + "], [" + target + "]");
                this.encodeURL(externalContext, config, target);
                return true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("PrettyFaces: redirect failed for target: " + action, e);
        }
        return false;
    }

    private void encodeURL(ExternalContext externalContext, PrettyConfig config, String target) throws IOException {
        String redirectUrl = externalContext.encodeActionURL(target);
        redirectUrl = config.isUseEncodeUrlForRedirects() ? ((HttpServletResponse)externalContext.getResponse()).encodeURL(redirectUrl) : ((HttpServletResponse)externalContext.getResponse()).encodeRedirectURL(redirectUrl);
        externalContext.redirect(redirectUrl);
    }

    public void send404(FacesContext facesContext) {
        try {
            HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
            response.sendError(404);
        }
        catch (IOException e) {
            throw new PrettyException(e);
        }
    }

    private boolean isPrettyNavigationCase(PrettyContext prettyContext, String action) {
        PrettyConfig config = prettyContext.getConfig();
        return action != null && config.isMappingId(action) && action.trim().startsWith("pretty:");
    }
}

