/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.prettyfaces;

import com.ocpsoft.pretty.faces.config.rewrite.RewriteRule;
import com.ocpsoft.pretty.faces.rewrite.RewriteEngine;
import com.ocpsoft.pretty.faces.url.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpOutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.urlbuilder.Address;
import org.ocpsoft.urlbuilder.AddressBuilder;

public class OutboundRewriteRuleAdaptor
implements Rule {
    private final RewriteRule rule;

    public OutboundRewriteRuleAdaptor(RewriteRule rule) {
        this.rule = rule;
    }

    private String stripContextPath(String contextPath, String uri) {
        if (uri.startsWith(contextPath)) {
            uri = uri.substring(contextPath.length());
        }
        return uri;
    }

    public String getId() {
        return this.toString();
    }

    public boolean evaluate(Rewrite event, EvaluationContext context) {
        if (event instanceof HttpOutboundServletRewrite && this.rule.isOutbound()) {
            Address outboundResource = ((HttpOutboundServletRewrite)event).getAddress();
            String outboundUrl = outboundResource.toString();
            if (outboundUrl.startsWith(((HttpServletRewrite)event).getContextPath())) {
                outboundUrl = outboundUrl.substring(((HttpServletRewrite)event).getContextPath().length());
            }
            if (this.rule.matches(URL.build(outboundUrl).decode().toURL())) {
                return true;
            }
        }
        return false;
    }

    public void perform(Rewrite event, EvaluationContext context) {
        RewriteEngine engine = new RewriteEngine();
        HttpOutboundServletRewrite outbound = (HttpOutboundServletRewrite)event;
        String url = ((Address)outbound.getOutboundAddress()).toString();
        String strippedUrl = this.stripContextPath(outbound.getContextPath(), url);
        String result = "";
        if (!strippedUrl.equals(url)) {
            result = outbound.getContextPath();
        }
        strippedUrl = engine.processOutbound((HttpServletRequest)((HttpServletRewrite)event).getRequest(), (HttpServletResponse)((HttpServletRewrite)event).getResponse(), this.rule, strippedUrl);
        result = result + strippedUrl;
        outbound.setOutboundAddress(AddressBuilder.create((String)result));
    }
}

