/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty;

import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.url.QueryString;
import com.ocpsoft.pretty.faces.url.URL;
import com.ocpsoft.pretty.faces.util.Assert;
import java.io.IOException;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ocpsoft.shade.org.apache.commons.logging.Log;
import org.ocpsoft.shade.org.apache.commons.logging.LogFactory;

public class PrettyContext
implements Serializable {
    private static final String DEFAULT_ENCODING = "UTF-8";
    public static final String CONFIG_KEY = "com.ocpsoft.pretty.CONFIG_FILES";
    private static final Log log = LogFactory.getLog(PrettyContext.class);
    private static final long serialVersionUID = -4593906924975844541L;
    public static final String PRETTY_PREFIX = "pretty:";
    private static final String CONTEXT_REQUEST_KEY = "prettyContext";
    private static final Pattern JSESSIONID_PATTERN = Pattern.compile("(?i)^(.*);jsessionid=[\\w\\.\\-\\+]+(.*)");
    private static final String JSESSIONID_REPLACEMENT = "$1$2";
    private PrettyConfig config;
    private final String contextPath;
    private URL requestURL;
    private final QueryString requestQuery;
    private UrlMapping currentMapping;
    private boolean dynaviewProcessed = false;
    private boolean inNavigation = false;

    protected PrettyContext(HttpServletRequest request) {
        Assert.notNull(request, "HttpServletRequest argument was null");
        this.config = (PrettyConfig)request.getAttribute(CONFIG_KEY);
        if (this.config == null) {
            this.config = new PrettyConfig();
        }
        this.contextPath = request.getContextPath();
        String requestUrl = this.stripContextPath(request.getRequestURI());
        Matcher sessionIdMatcher = JSESSIONID_PATTERN.matcher(requestUrl);
        if (sessionIdMatcher.matches()) {
            requestUrl = sessionIdMatcher.replaceFirst(JSESSIONID_REPLACEMENT);
        }
        String encoding = request.getCharacterEncoding() == null ? DEFAULT_ENCODING : request.getCharacterEncoding();
        this.requestURL = new URL(requestUrl);
        this.requestURL.setEncoding(encoding);
        this.requestURL = this.requestURL.decode();
        this.requestQuery = QueryString.build(request.getQueryString());
        log.trace("Initialized PrettyContext");
    }

    public static PrettyContext getCurrentInstance() {
        FacesContext context = FacesContext.getCurrentInstance();
        return PrettyContext.getCurrentInstance(context);
    }

    public static PrettyContext getCurrentInstance(FacesContext context) {
        Assert.notNull(context, "FacesContext argument was null.");
        return PrettyContext.getCurrentInstance((HttpServletRequest)context.getExternalContext().getRequest());
    }

    public static PrettyContext getCurrentInstance(HttpServletRequest request) {
        Assert.notNull(request, "HttpServletRequest argument was null");
        PrettyContext prettyContext = (PrettyContext)request.getAttribute(CONTEXT_REQUEST_KEY);
        if (prettyContext instanceof PrettyContext) {
            log.trace("Retrieved PrettyContext from Request");
            return prettyContext;
        }
        Assert.notNull(request, "HttpServletRequest argument was null");
        prettyContext = PrettyContext.newDetachedInstance(request);
        log.trace("PrettyContext not found in Request - building new instance");
        PrettyContext.setCurrentContext(request, prettyContext);
        return prettyContext;
    }

    public static boolean isInstantiated(ServletRequest request) {
        Assert.notNull(request, "HttpServletRequest argument was null");
        PrettyContext prettyContext = (PrettyContext)request.getAttribute(CONTEXT_REQUEST_KEY);
        return prettyContext instanceof PrettyContext;
    }

    public static PrettyContext newDetachedInstance(HttpServletRequest request) {
        Assert.notNull(request, "HttpServletRequest argument was null");
        PrettyContext prettyContext = new PrettyContext(request);
        return prettyContext;
    }

    public static void setCurrentContext(HttpServletRequest request, PrettyContext prettyContext) {
        request.setAttribute(CONTEXT_REQUEST_KEY, (Object)prettyContext);
    }

    public URL getRequestURL() {
        return this.requestURL;
    }

    public QueryString getRequestQueryString() {
        return this.requestQuery;
    }

    public boolean isPrettyRequest() {
        return this.getCurrentMapping() != null;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String stripContextPath(String uri) {
        if (!this.contextPath.equals("/") && uri.startsWith(this.contextPath)) {
            uri = uri.substring(this.contextPath.length());
        }
        return uri;
    }

    public PrettyConfig getConfig() {
        return this.config;
    }

    void setConfig(PrettyConfig config) {
        this.config = config;
    }

    public UrlMapping getCurrentMapping() {
        if (this.currentMapping == null) {
            this.currentMapping = this.config.getMappingForUrl(this.requestURL);
        }
        return this.currentMapping;
    }

    void setCurrentMapping(UrlMapping mapping) {
        this.currentMapping = mapping;
    }

    public String getCurrentViewId() {
        if (this.getCurrentMapping() != null) {
            return this.currentMapping.getViewId();
        }
        return "";
    }

    public boolean isInNavigation() {
        return this.inNavigation;
    }

    public void setInNavigation(boolean value) {
        this.inNavigation = value;
    }

    public boolean shouldProcessDynaview() {
        if (this.isPrettyRequest()) {
            return this.getCurrentMapping().isDynaView() && !this.isDynaviewProcessed();
        }
        return false;
    }

    public boolean isDynaviewProcessed() {
        return this.dynaviewProcessed;
    }

    public void setDynaviewProcessed(boolean value) {
        this.dynaviewProcessed = value;
    }

    public String getDynaViewId() {
        return this.config.getDynaviewId();
    }

    public void sendError(int code) {
        this.sendError(code, null);
    }

    public void sendError(int code, String message) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Assert.notNull(facesContext, "FacesContext argument was null.");
        Object response = facesContext.getExternalContext().getResponse();
        if (response instanceof HttpServletResponse) {
            this.sendError(code, message, (HttpServletResponse)response);
            facesContext.responseComplete();
        }
    }

    public void sendError(int code, String message, HttpServletResponse response) {
        Assert.notNull(response, "HttpServletResponse argument was null");
        try {
            if (message != null) {
                response.sendError(code, message);
            } else {
                response.sendError(code);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to send error code: " + code, e);
        }
    }
}

