/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces2.component;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.beans.ExtractedValuesURLBuilder;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import javax.faces.component.behavior.ClientBehaviorBase;
import javax.faces.component.behavior.ClientBehaviorContext;
import org.ocpsoft.shade.org.apache.commons.logging.Log;
import org.ocpsoft.shade.org.apache.commons.logging.LogFactory;

public class LocationBehavior
extends ClientBehaviorBase {
    private static final Log log = LogFactory.getLog(LocationBehavior.class);
    private String mappingId;
    private String url;

    public String getScript(ClientBehaviorContext behaviorContext) {
        if (this.url != null && this.url.trim().length() > 0) {
            return this.buildScriptInternal(this.url.trim());
        }
        if (this.mappingId == null || this.mappingId.trim().length() == 0) {
            log.error("Please set either 'mappingId' or 'url' attribute!");
            return null;
        }
        PrettyContext prettyContext = PrettyContext.getCurrentInstance(behaviorContext.getFacesContext());
        if (prettyContext == null) {
            log.error("Cannot build script because PrettyContext is not available!");
            return null;
        }
        UrlMapping mapping = prettyContext.getConfig().getMappingById(this.mappingId.trim());
        if (mapping == null) {
            log.error("Cannot find URL mapping with id: " + this.mappingId);
            return null;
        }
        try {
            ExtractedValuesURLBuilder builder = new ExtractedValuesURLBuilder();
            String contextPath = prettyContext.getContextPath();
            String path = contextPath + builder.buildURL(mapping) + builder.buildQueryString(mapping);
            return this.buildScriptInternal(path);
        }
        catch (PrettyException e) {
            log.error("Failed to build URL", e);
            return null;
        }
    }

    private String buildScriptInternal(String url) {
        StringBuilder builder = new StringBuilder();
        builder.append("window.location.href = '");
        builder.append(url);
        builder.append("'; return false;");
        return builder.toString();
    }

    public String getMappingId() {
        return this.mappingId;
    }

    public void setMappingId(String mappingId) {
        this.mappingId = mappingId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

