/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.beans;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.beans.ParameterInjector;
import com.ocpsoft.pretty.faces.config.mapping.PathParameter;
import com.ocpsoft.pretty.faces.config.mapping.PathValidator;
import com.ocpsoft.pretty.faces.config.mapping.QueryParameter;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.url.URL;
import com.ocpsoft.pretty.faces.util.FacesElUtils;
import com.ocpsoft.pretty.faces.util.NullComponent;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.servlet.http.HttpServletResponse;
import org.ocpsoft.shade.org.apache.commons.logging.Log;
import org.ocpsoft.shade.org.apache.commons.logging.LogFactory;

public class ParameterValidator {
    private static final Log log = LogFactory.getLog(ParameterInjector.class);
    private static final FacesElUtils elUtils = new FacesElUtils();

    public void validateParameters(FacesContext context) {
        log.trace("Validating parameters.");
        PrettyContext prettyContext = PrettyContext.getCurrentInstance(context);
        URL url = prettyContext.getRequestURL();
        UrlMapping mapping = prettyContext.getCurrentMapping();
        if (mapping != null) {
            this.validatePathParams(context, url, mapping);
            this.validateQueryParams(context, mapping);
        }
    }

    private void validatePathParams(FacesContext context, URL url, UrlMapping mapping) {
        List<PathParameter> params = mapping.getPatternParser().parse(url);
        PathParameter currentParameter = new PathParameter();
        PathValidator currentPathValidator = new PathValidator();
        String currentValidatorId = "";
        try {
            Iterator<PathParameter> iterator = params.iterator();
            while (iterator.hasNext()) {
                PathParameter param;
                currentParameter = param = iterator.next();
                List<PathValidator> validators = mapping.getValidatorsForPathParam(param);
                if (validators == null || validators.size() <= 0) continue;
                String value = param.getValue();
                Object coerced = elUtils.coerceToType(context, param.getExpression().getELExpression(), value);
                Iterator<PathValidator> iterator2 = validators.iterator();
                while (iterator2.hasNext()) {
                    PathValidator pv;
                    currentPathValidator = pv = iterator2.next();
                    Iterator<String> iterator3 = pv.getValidatorIdList().iterator();
                    while (iterator3.hasNext()) {
                        String id;
                        currentValidatorId = id = iterator3.next();
                        Validator validator = context.getApplication().createValidator(id);
                        validator.validate(context, (UIComponent)new NullComponent(), coerced);
                    }
                    if (pv.getValidatorExpression() == null) continue;
                    elUtils.invokeMethod(context, pv.getValidatorExpression().getELExpression(), new Class[]{FacesContext.class, UIComponent.class, Object.class}, new Object[]{context, new NullComponent(), coerced});
                }
            }
        }
        catch (ELException e) {
            FacesMessage message = new FacesMessage("Could not coerce value [" + currentParameter.getValue() + "] on mappingId [" + mapping.getId() + "] to type in location [" + currentParameter.getExpression() + "]");
            this.handleValidationFailure(context, message, currentPathValidator.getOnError());
        }
        catch (ValidatorException e) {
            this.handleValidationFailure(context, e.getFacesMessage(), currentPathValidator.getOnError());
        }
        catch (FacesException e) {
            FacesMessage message = new FacesMessage("Error occurred invoking validator with id [" + currentValidatorId + "] on mappingId [" + mapping.getId() + "] parameter [" + currentParameter.getExpression() + "] at position [" + currentParameter.getPosition() + "]");
            this.handleValidationFailure(context, message, currentPathValidator.getOnError());
        }
    }

    private void validateQueryParams(FacesContext context, UrlMapping mapping) {
        QueryParameter currentParameter = new QueryParameter();
        String currentValidatorId = "";
        try {
            List<QueryParameter> params = mapping.getQueryParams();
            for (QueryParameter param : params) {
                Validator validator;
                String id;
                Iterator<String> iterator;
                Object coerced;
                if (!param.hasValidators() && param.getValidatorExpression() == null) continue;
                currentParameter = param;
                String name = param.getName();
                String el = param.getExpression().getELExpression();
                if (elUtils.getExpectedType(context, el).isArray()) {
                    String[] values = (String[])context.getExternalContext().getRequestParameterValuesMap().get(name);
                    if (values == null) continue;
                    coerced = elUtils.coerceToType(context, el, values);
                    iterator = param.getValidatorIdList().iterator();
                    while (iterator.hasNext()) {
                        currentValidatorId = id = iterator.next();
                        validator = context.getApplication().createValidator(id);
                        validator.validate(context, (UIComponent)new NullComponent(), coerced);
                    }
                    if (param.getValidatorExpression() == null) continue;
                    elUtils.invokeMethod(context, param.getValidatorExpression().getELExpression(), new Class[]{FacesContext.class, UIComponent.class, Object.class}, new Object[]{context, new NullComponent(), coerced});
                    continue;
                }
                String value = (String)context.getExternalContext().getRequestParameterMap().get(name);
                if (value == null) continue;
                coerced = elUtils.coerceToType(context, el, value);
                iterator = param.getValidatorIdList().iterator();
                while (iterator.hasNext()) {
                    currentValidatorId = id = iterator.next();
                    validator = context.getApplication().createValidator(id);
                    validator.validate(context, (UIComponent)new NullComponent(), coerced);
                }
                if (param.getValidatorExpression() == null) continue;
                elUtils.invokeMethod(context, param.getValidatorExpression().getELExpression(), new Class[]{FacesContext.class, UIComponent.class, Object.class}, new Object[]{context, new NullComponent(), coerced});
            }
        }
        catch (ELException e) {
            FacesMessage message = new FacesMessage("Could not coerce value [" + currentParameter.getValue() + "] on mappingId [" + mapping.getId() + "] to type [" + elUtils.getExpectedType(context, currentParameter.getExpression().getELExpression()) + "]");
            this.handleValidationFailure(context, message, currentParameter.getOnError());
        }
        catch (ValidatorException e) {
            this.handleValidationFailure(context, e.getFacesMessage(), currentParameter.getOnError());
        }
        catch (FacesException e) {
            FacesMessage message = new FacesMessage("Error occurred invoking validator with id [" + currentValidatorId + "] on mappingId [" + mapping.getId() + "] parameter [" + currentParameter.getName() + "]");
            this.handleValidationFailure(context, message, currentParameter.getOnError());
        }
    }

    private void handleValidationFailure(FacesContext context, FacesMessage message, String onError) {
        boolean continueToFaces = false;
        if (onError != null && !"".equals(onError.trim())) {
            if (elUtils.isEl(onError)) {
                Object result = elUtils.invokeMethod(context, onError);
                if (result == null) {
                    continueToFaces = true;
                } else {
                    onError = result.toString();
                }
            }
            if (onError != null) {
                String viewId = context.getViewRoot().getViewId();
                context.getApplication().getNavigationHandler().handleNavigation(context, viewId, onError);
            }
        }
        if (!context.getResponseComplete() && !continueToFaces) {
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            try {
                response.sendError(404);
                context.responseComplete();
            }
            catch (IOException e1) {
                throw new PrettyException(e1);
            }
        }
    }
}

