/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.servlet;

import com.ocpsoft.pretty.PrettyException;
import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.mapping.PathParameter;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.config.rewrite.RewriteRule;
import com.ocpsoft.pretty.faces.rewrite.RewriteEngine;
import com.ocpsoft.pretty.faces.url.QueryString;
import com.ocpsoft.pretty.faces.util.PrettyURLBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIParameter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class PrettyFacesWrappedResponse
extends HttpServletResponseWrapper {
    public static final String REWRITE_MAPPING_ID_KEY = "com.ocpsoft.mappingId";
    private final RewriteEngine rewriteEngine = new RewriteEngine();
    private final PrettyConfig prettyConfig;
    private final String contextPath;
    private final HttpServletRequest request;
    private static final Comparator<UrlMapping> ORDINAL_COMPARATOR = new Comparator<UrlMapping>(){

        @Override
        public int compare(UrlMapping l, UrlMapping r) {
            if (l.getPatternParser().getParameterCount() < r.getPatternParser().getParameterCount()) {
                return 1;
            }
            if (l.getPatternParser().getParameterCount() > r.getPatternParser().getParameterCount()) {
                return -1;
            }
            return 0;
        }
    };

    public PrettyFacesWrappedResponse(String contextPath, HttpServletRequest request, HttpServletResponse response, PrettyConfig config) {
        super(response);
        this.request = request;
        this.contextPath = contextPath;
        this.prettyConfig = config;
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        return super.encodeRedirectURL(url);
    }

    public String encodeRedirectURL(String url) {
        return super.encodeRedirectURL(url);
    }

    @Deprecated
    public String encodeUrl(String url) {
        return super.encodeURL(url);
    }

    public String encodeURL(String url) {
        String result = this.rewritePrettyMappings(url);
        result = this.rewrite(result);
        return super.encodeURL(result);
    }

    private String rewritePrettyMappings(String url) {
        String result = url;
        if (url != null) {
            String strippedUrl = this.stripContextPath(url);
            ArrayList<UrlMapping> matches = new ArrayList<UrlMapping>();
            QueryString queryString = QueryString.build("");
            String mappingId = null;
            if (strippedUrl.contains("?")) {
                queryString.addParameters(strippedUrl);
                mappingId = queryString.getParameter(REWRITE_MAPPING_ID_KEY);
                queryString.removeParameter(REWRITE_MAPPING_ID_KEY);
            }
            if (mappingId != null) {
                matches.add(this.prettyConfig.getMappingById(mappingId));
            } else {
                for (UrlMapping m : this.prettyConfig.getMappings()) {
                    if ("".equals(m.getViewId()) || !strippedUrl.startsWith(m.getViewId())) continue;
                    matches.add(m);
                }
            }
            Collections.sort(matches, ORDINAL_COMPARATOR);
            for (UrlMapping m : matches) {
                UIParameter uip;
                if (!m.isOutbound()) continue;
                ArrayList<UIParameter> uiParams = new ArrayList<UIParameter>();
                Map<String, String[]> queryParams = queryString.getParameterMap();
                List<PathParameter> pathParams = m.getPatternParser().getPathParameters();
                int pathParamsFound = 0;
                for (PathParameter pathParameter : pathParams) {
                    uip = new UIParameter();
                    String[] values = queryParams.get(pathParameter.getName());
                    if (values != null && values.length > 0) {
                        String value = values[0];
                        uip.setValue((Object)value);
                        if (value != null && !"".equals(value)) {
                            ++pathParamsFound;
                        }
                    }
                    queryParams.remove(pathParameter.getName());
                    uiParams.add(uip);
                }
                for (Map.Entry entry : queryParams.entrySet()) {
                    uip = new UIParameter();
                    uip.setName((String)entry.getKey());
                    uip.setValue(entry.getValue());
                    uiParams.add(uip);
                }
                if (pathParams.size() != pathParamsFound) continue;
                PrettyURLBuilder builder = new PrettyURLBuilder();
                result = this.contextPath + builder.build(m, true, uiParams);
                break;
            }
        }
        return result;
    }

    private String rewrite(String url) {
        String result = "";
        if (url != null) {
            String strippedUrl = this.stripContextPath(url);
            if (!strippedUrl.equals(url)) {
                result = this.contextPath;
            }
            try {
                for (RewriteRule c : this.prettyConfig.getGlobalRewriteRules()) {
                    strippedUrl = this.rewriteEngine.processOutbound(this.request, (HttpServletResponse)this, c, strippedUrl);
                }
                result = result + strippedUrl;
            }
            catch (Exception e) {
                throw new PrettyException("Error occurred during canonicalization of request <[" + url + "]>", e);
            }
        }
        return result;
    }

    private String stripContextPath(String uri) {
        if (!this.contextPath.equals("/") && uri.startsWith(this.contextPath)) {
            uri = uri.substring(this.contextPath.length());
        }
        return uri;
    }
}

