/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.url;

import com.ocpsoft.pretty.faces.url.Metadata;
import com.ocpsoft.pretty.faces.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ocpsoft.urlbuilder.util.Decoder;
import org.ocpsoft.urlbuilder.util.Encoder;

public class URL {
    private Metadata metadata = new Metadata();
    private String originalURL = "";
    private List<String> segments;
    private final Map<String, List<String>> decodedSegments = new LinkedHashMap<String, List<String>>();

    public URL(String url) {
        if (url != null) {
            this.originalURL = url = url.trim();
            if (StringUtils.hasLeadingSlash(url)) {
                this.metadata.setLeadingSlash(true);
                url = url.substring(1);
            }
            if (StringUtils.hasTrailingSlash(url)) {
                this.metadata.setTrailingSlash(true);
                url = url.substring(0, url.length() - 1);
            }
        } else {
            throw new IllegalArgumentException("URL cannot be null.");
        }
        this.segments = Arrays.asList(StringUtils.splitBySlash(url));
    }

    public static URL build(String url) {
        return new URL(url);
    }

    public URL(List<String> segments, Metadata metadata) {
        this.metadata = metadata;
        this.segments = segments;
        this.originalURL = metadata.buildURLFromSegments(segments);
    }

    public static URL build(List<String> segments, Metadata metadata) {
        return new URL(segments, metadata);
    }

    public List<String> getDecodedSegments() {
        String encoding = this.metadata.getEncoding();
        if (!this.decodedSegments.containsKey(encoding)) {
            ArrayList<String> result = new ArrayList<String>();
            for (String segment : this.segments) {
                result.add(Decoder.path((CharSequence)segment));
            }
            this.decodedSegments.put(encoding, Collections.unmodifiableList(result));
        }
        return this.decodedSegments.get(encoding);
    }

    public List<String> getEncodedSegments() {
        ArrayList<String> resultSegments = new ArrayList<String>();
        for (String segment : this.segments) {
            resultSegments.add(Encoder.path((CharSequence)segment));
        }
        return resultSegments;
    }

    public URL decode() {
        return new URL(this.getDecodedSegments(), this.metadata);
    }

    public URL encode() {
        return new URL(this.getEncodedSegments(), this.metadata);
    }

    public int numSegments() {
        return this.segments.size();
    }

    public String toString() {
        return this.toURL();
    }

    public String toURL() {
        return this.originalURL;
    }

    public List<String> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public boolean hasLeadingSlash() {
        return this.metadata.hasLeadingSlash();
    }

    public boolean hasTrailingSlash() {
        return this.metadata.hasTrailingSlash();
    }

    public String getEncoding() {
        return this.metadata.getEncoding();
    }

    public void setEncoding(String encoding) {
        this.metadata.setEncoding(encoding);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }
}

