/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces2.application;

import com.ocpsoft.pretty.PrettyContext;
import com.ocpsoft.pretty.faces.application.PrettyRedirector;
import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.dynaview.DynaviewEngine;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.url.QueryString;
import com.ocpsoft.pretty.faces.url.URL;
import com.ocpsoft.pretty.faces.util.FacesNavigationURLCanonicalizer;
import jakarta.faces.application.ConfigurableNavigationHandler;
import jakarta.faces.application.NavigationCase;
import jakarta.faces.context.FacesContext;
import java.util.Map;
import java.util.Set;
import org.ocpsoft.shade.org.apache.commons.logging.Log;
import org.ocpsoft.shade.org.apache.commons.logging.LogFactory;

public class PrettyNavigationHandler
extends ConfigurableNavigationHandler {
    private static final Log log = LogFactory.getLog(PrettyNavigationHandler.class);
    private final ConfigurableNavigationHandler parent;
    private final PrettyRedirector pr = PrettyRedirector.getInstance();
    private final DynaviewEngine dynaview = new DynaviewEngine();

    public PrettyNavigationHandler(ConfigurableNavigationHandler parent) {
        this.parent = parent;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        log.debug("Navigation requested: fromAction [" + fromAction + "], outcome [" + outcome + "]");
        if (!this.pr.redirect(context, outcome)) {
            log.debug("Not a PrettyFaces navigation string - passing control to default nav-handler");
            PrettyContext prettyContext = PrettyContext.getCurrentInstance(context);
            prettyContext.setInNavigation(true);
            String originalViewId = context.getViewRoot().getViewId();
            this.parent.handleNavigation(context, fromAction, outcome);
            String newViewId = context.getViewRoot().getViewId();
            if (context.getResponseComplete() || originalViewId.equals(newViewId)) {
                prettyContext.setInNavigation(false);
            }
        }
    }

    public NavigationCase getNavigationCase(FacesContext context, String fromAction, String outcome) {
        PrettyContext prettyContext = PrettyContext.getCurrentInstance(context);
        PrettyConfig config = prettyContext.getConfig();
        if (outcome != null && "pretty:".equals(outcome)) {
            String viewId = context.getViewRoot().getViewId();
            NavigationCase navigationCase = this.parent.getNavigationCase(context, fromAction, viewId);
            return navigationCase;
        }
        if (outcome != null && outcome.startsWith("pretty:") && config.isMappingId(outcome)) {
            UrlMapping mapping = config.getMappingById(outcome);
            Object viewId = mapping.getViewId();
            if (mapping.isDynaView()) {
                viewId = this.dynaview.calculateDynaviewId(context, mapping);
            }
            viewId = FacesNavigationURLCanonicalizer.normalizeRequestURI(context, (String)viewId);
            URL url = new URL((String)viewId);
            url.getMetadata().setLeadingSlash(true);
            QueryString qs = QueryString.build("");
            if (((String)viewId).contains("?")) {
                qs.addParameters((String)viewId);
            }
            qs.addParameters("?com.ocpsoft.mappingId=" + mapping.getId());
            viewId = url.toString() + qs.toQueryString();
            NavigationCase navigationCase = this.parent.getNavigationCase(context, fromAction, (String)viewId);
            return navigationCase;
        }
        NavigationCase navigationCase = this.parent.getNavigationCase(context, fromAction, outcome);
        return navigationCase;
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        return this.parent.getNavigationCases();
    }

    public void performNavigation(String outcome) {
        this.parent.performNavigation(outcome);
    }
}

