/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.prettyfaces;

import com.ocpsoft.pretty.faces.config.PrettyConfig;
import com.ocpsoft.pretty.faces.config.mapping.UrlMapping;
import com.ocpsoft.pretty.faces.config.rewrite.RewriteRule;
import jakarta.servlet.ServletContext;
import java.util.List;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.prettyfaces.InboundRewriteRuleAdaptor;
import org.ocpsoft.rewrite.prettyfaces.OutboundRewriteRuleAdaptor;
import org.ocpsoft.rewrite.prettyfaces.UrlMappingRuleAdaptor;
import org.ocpsoft.rewrite.servlet.config.HttpConfigurationProvider;

public class PrettyFacesRewriteConfigurationProvider
extends HttpConfigurationProvider {
    public int priority() {
        return 1;
    }

    public Configuration getConfiguration(ServletContext context) {
        ConfigurationBuilder builder = ConfigurationBuilder.begin();
        PrettyConfig config = (PrettyConfig)context.getAttribute("com.ocpsoft.pretty.CONFIG_FILES");
        if (config != null) {
            List<RewriteRule> rules = config.getGlobalRewriteRules();
            List<UrlMapping> mappings = config.getMappings();
            for (RewriteRule rule : rules) {
                builder.addRule((Rule)new InboundRewriteRuleAdaptor(rule));
            }
            for (UrlMapping mapping : mappings) {
                builder.addRule((Rule)new UrlMappingRuleAdaptor(mapping));
            }
            for (RewriteRule rule : rules) {
                builder.addRule((Rule)new OutboundRewriteRuleAdaptor(rule));
            }
        }
        return builder;
    }
}

