/*
 * Decompiled with CFR 0.152.
 */
package com.ocpsoft.pretty.faces.config.servlet;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.ocpsoft.shade.org.apache.commons.logging.Log;
import org.ocpsoft.shade.org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class WebXmlParser {
    private static final Log log = LogFactory.getLog(WebXmlParser.class);
    private static final String FACES_SERVLET = "javax.faces.webapp.FacesServlet";
    private String facesMapping = null;

    public void parse(ServletContext context) throws IOException, SAXException {
        for (ServletRegistration s : context.getServletRegistrations().values()) {
            Collection mappings;
            if (s.getClassName() == null || !s.getClassName().equalsIgnoreCase(FACES_SERVLET) || (mappings = s.getMappings()).isEmpty()) continue;
            this.facesMapping = (String)mappings.iterator().next();
            break;
        }
        if (this.facesMapping == null) {
            log.warn("Faces Servlet (javax.faces.webapp.FacesServlet) not found in web context - cannot configure PrettyFaces DynaView");
        }
    }

    public boolean isFacesPresent() {
        return this.facesMapping != null;
    }

    public String getFacesMapping() {
        if (this.isFacesPresent()) {
            return this.facesMapping;
        }
        return "";
    }
}

