/*
 * Copyright 2010 Lincoln Baxter, III
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.ocpsoft.pretty.faces.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;

import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * <p>
 * Empty {@link EntityResolver} to disable downloading of external entities.
 * Will work without problems for the parts of the <code>faces-config.xml</code>
 * we are parsing.
 * </p>
 * 
 * @see http://wiki.apache.org/commons/Digester/FAQ
 */
public class EmptyEntityResolver implements EntityResolver
{

   public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException
   {
      return new InputSource(new ByteArrayInputStream(new byte[0]));
   }

}