/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.cdi;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.inject.Inject;
import org.ocpsoft.rewrite.cdi.expressions.Expressions;
import org.ocpsoft.rewrite.spi.ExpressionLanguageProvider;

public class CdiExpressionLanguageProvider
implements ExpressionLanguageProvider {
    @Inject
    private Expressions expressions;

    public Object retrieveValue(String expression) {
        return this.getValue(this.expressions.getELContext(), this.expressions.getExpressionFactory(), this.groomExpression(expression));
    }

    public void submitValue(String expression, Object value) {
        String el = this.groomExpression(expression);
        if (this.getExpectedType(this.expressions.getELContext(), this.expressions.getExpressionFactory(), el).isArray()) {
            Object[] toInject = null;
            toInject = value != null && !value.getClass().isArray() ? new Object[]{value} : (Object[])value;
            this.setValue(this.expressions.getELContext(), this.expressions.getExpressionFactory(), el, toInject);
        } else {
            Object toInject = value;
            if (value != null && value.getClass().isArray()) {
                Object[] array = (Object[])value;
                toInject = array.length > 0 ? array[0] : "";
            }
            this.setValue(this.expressions.getELContext(), this.expressions.getExpressionFactory(), el, toInject);
        }
    }

    public String groomExpression(String expression) {
        String result = expression.trim();
        if (!result.startsWith("#{")) {
            return this.expressions.toExpression(result);
        }
        return result;
    }

    public Object evaluateMethodExpression(String expression) {
        String el = this.groomExpression(expression);
        return this.expressions.evaluateMethodExpression(el);
    }

    public Object evaluateMethodExpression(String expression, Object ... values) {
        String el = this.groomExpression(expression);
        return this.expressions.evaluateMethodExpression(el, values);
    }

    private Class<?> getExpectedType(ELContext context, ExpressionFactory factory, String expression) throws ELException {
        ValueExpression ve = factory.createValueExpression(context, expression, Object.class);
        return ve.getType(context);
    }

    private Object getValue(ELContext context, ExpressionFactory factory, String expression) throws ELException {
        ValueExpression ve = factory.createValueExpression(context, expression, Object.class);
        return ve.getValue(context);
    }

    private void setValue(ELContext context, ExpressionFactory factory, String expression, Object value) throws ELException {
        ValueExpression ve = factory.createValueExpression(context, expression, Object.class);
        ve.setValue(context, factory.coerceToType(value, ve.getType(context)));
    }
}

