/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.cdi;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.InjectionTargetFactory;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.ocpsoft.common.spi.ServiceEnricher;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.cdi.manager.BeanManagerAware;

public class CdiServiceEnricher
extends BeanManagerAware
implements ServiceEnricher {
    Logger log = Logger.getLogger(CdiServiceEnricher.class);

    public <T> Collection<T> produce(Class<T> type) {
        ArrayList<Object> result = new ArrayList<Object>();
        BeanManager manager = this.getBeanManager();
        Set beans = manager.getBeans(type, new Annotation[0]);
        for (Bean bean : beans) {
            CreationalContext context;
            if (bean == null || (context = manager.createCreationalContext((Contextual)bean)) == null) continue;
            result.add(manager.getReference(bean, type, context));
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Created CDI enriched service [" + bean.toString() + "]");
        }
        return result;
    }

    public <T> void enrich(T service) {
        if (service != null) {
            BeanManager manager = this.getBeanManager();
            InjectionTargetFactory targetFactory = manager.getInjectionTargetFactory(manager.createAnnotatedType(service.getClass()));
            InjectionTarget injectionTarget = targetFactory.createInjectionTarget(null);
            CreationalContext creationalContext = manager.createCreationalContext(null);
            injectionTarget.inject(service, creationalContext);
            if (creationalContext != null && this.log.isDebugEnabled()) {
                this.log.debug("Enriched non-contextual instance of service [" + service.getClass().getName() + "]");
            }
        }
    }
}

