/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.spring;

import java.util.HashSet;
import java.util.Set;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.el.spi.BeanNameResolver;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class SpringBeanNameResolver
implements BeanNameResolver {
    private final Logger log = Logger.getLogger(SpringBeanNameResolver.class);
    @Autowired
    private WebApplicationContext applicationContext;

    public String getBeanName(Class<?> clazz) {
        Set<String> beanNames;
        if (this.applicationContext == null) {
            this.applicationContext = ContextLoader.getCurrentWebApplicationContext();
            if (this.applicationContext == null) {
                throw new IllegalStateException("Unable to get current WebApplicationContext");
            }
        }
        if ((beanNames = this.resolveBeanNames((ListableBeanFactory)this.applicationContext, clazz)) == null || beanNames.size() == 0) {
            return null;
        }
        if (beanNames.size() > 1) {
            this.log.warn("Spring knows more than one bean of type [{}]", (Object)clazz.getName());
            return null;
        }
        return beanNames.iterator().next();
    }

    private Set<String> resolveBeanNames(ListableBeanFactory beanFactory, Class<?> clazz) {
        HashSet<String> result = new HashSet<String>();
        String[] names = beanFactory.getBeanNamesForType(clazz);
        if (names != null) {
            for (String name : names) {
                if (name == null || name.startsWith("scopedTarget.")) continue;
                result.add(name);
            }
        }
        return result;
    }
}

