/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.annotation.scan;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import org.ocpsoft.rewrite.annotation.api.ClassVisitor;
import org.ocpsoft.rewrite.annotation.scan.AbstractClassFinder;
import org.ocpsoft.rewrite.annotation.scan.ByteCodeFilter;
import org.ocpsoft.rewrite.annotation.scan.PackageFilter;

public class WebClassesFinder
extends AbstractClassFinder {
    private static final String CLASSES_FOLDER = "/WEB-INF/classes/";
    private final Set<String> processedClasses = new LinkedHashSet<String>();

    public WebClassesFinder(ServletContext servletContext, ClassLoader classLoader, PackageFilter packageFilter, ByteCodeFilter byteCodeFilter) {
        super(servletContext, classLoader, packageFilter, byteCodeFilter);
    }

    @Override
    public void findClasses(ClassVisitor visitor) {
        try {
            URL classesFolderUrl = this.servletContext.getResource(CLASSES_FOLDER);
            if (classesFolderUrl == null) {
                this.log.warn("Cannot find classes folder: /WEB-INF/classes/");
                return;
            }
            this.processDirectory(classesFolderUrl, CLASSES_FOLDER, visitor);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Invalid URL: " + e.getMessage(), e);
        }
    }

    protected void processDirectory(URL absoluteUrl, String relativePath, ClassVisitor visitor) throws MalformedURLException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Processing directory: " + relativePath);
        }
        String urlAsString = absoluteUrl.toString();
        Set paths = this.servletContext.getResourcePaths(relativePath);
        if (paths == null || paths.isEmpty()) {
            return;
        }
        for (Object obj : paths) {
            String childNodeName = obj.toString();
            String childNodeRelative = this.getChildNodeName(childNodeName);
            String webInfFolder = childNodeName.substring(0, childNodeName.length() - childNodeRelative.length());
            String urlBase = urlAsString.substring(0, urlAsString.length() - webInfFolder.length());
            URL childNodeUrl = new URL(urlBase + childNodeName);
            if (childNodeRelative.endsWith("/")) {
                this.processDirectory(childNodeUrl, childNodeName, visitor);
            }
            if (!childNodeRelative.endsWith(".class")) continue;
            this.handleClassEntry(childNodeName, visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClassEntry(String entryName, ClassVisitor visitor) {
        String className = WebClassesFinder.getClassName(entryName.substring(CLASSES_FOLDER.length()));
        if (this.mustProcessClass(className) && !this.processedClasses.contains(className)) {
            this.processedClasses.add(className);
            InputStream classFileStream = null;
            try {
                classFileStream = this.servletContext.getResourceAsStream(entryName);
                if (classFileStream == null && this.log.isDebugEnabled()) {
                    this.log.debug("Could not obtain InputStream for class file: " + entryName);
                }
                this.processClass(className, classFileStream, visitor);
            }
            finally {
                block11: {
                    try {
                        if (classFileStream != null) {
                            classFileStream.close();
                        }
                    }
                    catch (IOException e) {
                        if (!this.log.isDebugEnabled()) break block11;
                        this.log.debug("Failed to close input stream: " + e.getMessage());
                    }
                }
            }
        }
    }

    private String getChildNodeName(String path) {
        String[] elements = path.split("/");
        int size = elements.length;
        String nodeName = elements[size - 1];
        return path.endsWith("/") ? nodeName + "/" : nodeName;
    }

    @Override
    public int priority() {
        return 0;
    }
}

