/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.common.services;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ocpsoft.common.services.NonEnriching;
import org.ocpsoft.common.spi.ServiceEnricher;
import org.ocpsoft.common.spi.ServiceLocator;

public class ServiceLoader<S>
implements Iterable<S> {
    private static final String SERVICES = "META-INF/services";
    private final String serviceFile;
    private final Class<S> expectedType;
    private final ClassLoader loader;
    private Set<S> providers;
    private Set<Class<?>> loadedImplementations;
    private java.util.ServiceLoader<ServiceLocator> locatorLoader;
    private static java.util.ServiceLoader<ServiceEnricher> enricherLoader = null;

    public static <S> ServiceLoader load(Class<S> service) {
        return ServiceLoader.load(service, Thread.currentThread().getContextClassLoader());
    }

    public static <S> ServiceLoader<S> loadTypesafe(Class<S> service) {
        return ServiceLoader.load(service, Thread.currentThread().getContextClassLoader());
    }

    public static <S> ServiceLoader<S> load(Class<S> service, ClassLoader loader) {
        if (loader == null) {
            loader = service.getClassLoader();
        }
        return new ServiceLoader<S>(service, loader);
    }

    private ServiceLoader(Class<S> service, ClassLoader loader) {
        this.loader = loader;
        this.serviceFile = "META-INF/services/" + service.getName();
        this.expectedType = service;
    }

    public void reload() {
        this.providers = new HashSet<S>();
        this.loadedImplementations = new HashSet();
        for (URL serviceFile : this.loadServiceFiles()) {
            this.loadServiceFile(serviceFile);
        }
        if (this.locatorLoader == null) {
            this.locatorLoader = java.util.ServiceLoader.load(ServiceLocator.class);
        }
        for (ServiceLocator locator : this.locatorLoader) {
            Collection<Class<S>> serviceTypes = locator.locate(this.expectedType);
            if (serviceTypes == null || serviceTypes.isEmpty()) continue;
            for (Class<S> type : serviceTypes) {
                this.loadClass(type);
            }
        }
    }

    private List<URL> loadServiceFiles() {
        ArrayList<URL> serviceFiles = new ArrayList<URL>();
        try {
            Enumeration<URL> serviceFileEnumerator = this.loader.getResources(this.serviceFile);
            while (serviceFileEnumerator.hasMoreElements()) {
                serviceFiles.add(serviceFileEnumerator.nextElement());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load resources from " + this.serviceFile, e);
        }
        return serviceFiles;
    }

    private void loadServiceFile(URL serviceFile) {
        try (InputStream is = serviceFile.openStream();){
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            String serviceClassName = null;
            while ((serviceClassName = reader.readLine()) != null) {
                if ((serviceClassName = this.trim(serviceClassName)).length() <= 0) continue;
                this.loadService(serviceClassName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read services file " + serviceFile, e);
        }
    }

    private String trim(String line) {
        int comment = line.indexOf(35);
        if (comment > -1) {
            line = line.substring(0, comment);
        }
        return line.trim();
    }

    private void loadService(String serviceClassName) {
        Class<S> serviceClass = this.loadClass(serviceClassName);
        this.loadClass(serviceClass);
    }

    private void loadClass(Class<? extends S> serviceClass) {
        if (serviceClass == null) {
            return;
        }
        if (this.loadedImplementations.contains(serviceClass)) {
            return;
        }
        Collection<S> services = ServiceLoader.loadEnriched(serviceClass);
        if (services == null || services.isEmpty()) {
            return;
        }
        for (S service : services) {
            this.loadedImplementations.add(service.getClass());
        }
        this.providers.addAll(services);
    }

    private Class<? extends S> loadClass(String serviceClassName) {
        Class<?> clazz = null;
        Class<S> serviceClass = null;
        try {
            clazz = this.loader.loadClass(serviceClassName);
            serviceClass = clazz.asSubclass(this.expectedType);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("ClassNotFoundException: Service class [" + serviceClassName + "] could not be loaded.");
        }
        catch (ClassCastException e) {
            throw new ClassCastException("ClassCastException: Service class [" + serviceClassName + "] did not implement the interface [" + this.expectedType.getName() + "]");
        }
        return serviceClass;
    }

    public static <T> Collection<T> loadEnriched(Class<T> serviceClass) {
        try {
            Collection services = Collections.emptyList();
            ServiceEnricher origin = null;
            if (!NonEnriching.class.isAssignableFrom(serviceClass)) {
                if (enricherLoader == null) {
                    enricherLoader = java.util.ServiceLoader.load(ServiceEnricher.class);
                }
                for (ServiceEnricher enricher : enricherLoader) {
                    services = enricher.produce(serviceClass);
                    if (services == null) {
                        services = Collections.emptyList();
                    }
                    if (services.isEmpty()) continue;
                    origin = enricher;
                    break;
                }
            }
            if (services.isEmpty()) {
                Constructor<T> constructor = serviceClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                services = Collections.singletonList(constructor.newInstance(new Object[0]));
            }
            if (!NonEnriching.class.isAssignableFrom(serviceClass)) {
                for (ServiceEnricher enricher : enricherLoader) {
                    if (enricher.equals(origin)) continue;
                    for (Object service : services) {
                        enricher.enrich(service);
                    }
                }
            }
            return services;
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("Could not instantiate service class " + serviceClass.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error instantiating " + serviceClass, e.getCause());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException e) {
            throw new RuntimeException("Error instantiating " + serviceClass, e);
        }
    }

    @Override
    public Iterator<S> iterator() {
        if (this.providers == null) {
            this.reload();
        }
        return this.providers.iterator();
    }

    public String toString() {
        return "Services for " + this.serviceFile;
    }
}

