/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config.bind;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.ocpsoft.rewrite.bind.Binding;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.servlet.RewriteWrappedRequest;
import org.ocpsoft.rewrite.servlet.event.ServletRewrite;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;
import org.ocpsoft.rewrite.util.Maps;

public abstract class RequestBinding
implements Binding {
    public static RequestBinding attribute(final String property) {
        return new RequestAttributeBinding(property){

            public String toString() {
                return "RequestBinding.attribute(\"" + property + "\")";
            }
        };
    }

    public static RequestBinding parameter(final String property) {
        return new RequestParameterBinding(property){

            public String toString() {
                return "RequestBinding.parameter(\"" + property + "\")";
            }
        };
    }

    @Override
    public boolean supportsRetrieval() {
        return true;
    }

    @Override
    public boolean supportsSubmission() {
        return true;
    }

    private static class RequestAttributeBinding
    extends RequestBinding {
        private final String name;

        public RequestAttributeBinding(String attribute) {
            this.name = attribute;
        }

        @Override
        public Object submit(Rewrite event, EvaluationContext context, Object value) {
            ((HttpServletRequest)((HttpServletRewrite)event).getRequest()).setAttribute(this.name, value);
            return null;
        }

        @Override
        public Object retrieve(Rewrite event, EvaluationContext context) {
            if (event instanceof HttpServletRewrite) {
                return ((HttpServletRequest)((HttpServletRewrite)event).getRequest()).getParameter(this.name);
            }
            return null;
        }
    }

    private static class RequestParameterBinding
    extends RequestBinding {
        private final String name;

        public RequestParameterBinding(String parameter) {
            this.name = parameter;
        }

        @Override
        public Object submit(Rewrite event, EvaluationContext context, Object value) {
            Object request = ((ServletRewrite)event).getRequest();
            RewriteWrappedRequest wrapper = RewriteWrappedRequest.getCurrentInstance(request);
            Map<String, String[]> modifiableParameters = wrapper.getModifiableParameters();
            if (value != null) {
                if (value.getClass().isArray()) {
                    Object[] values;
                    for (Object object : values = (Object[])value) {
                        Maps.addArrayValue(modifiableParameters, this.name, object.toString());
                    }
                } else {
                    Maps.addArrayValue(modifiableParameters, this.name, value.toString());
                }
            } else {
                Maps.addArrayValue(modifiableParameters, this.name, null);
            }
            return null;
        }

        @Override
        public Object retrieve(Rewrite event, EvaluationContext context) {
            return ((HttpServletRequest)((HttpServletRewrite)event).getRequest()).getParameter(this.name);
        }
    }
}

