/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.util;

import java.util.List;

public class Metadata {
    private String encoding = "UTF-8";
    private boolean trailingSlash = false;
    private boolean leadingSlash = false;

    public Metadata copy() {
        Metadata result = new Metadata();
        result.setEncoding(this.encoding);
        result.setTrailingSlash(this.trailingSlash);
        result.setLeadingSlash(this.leadingSlash);
        return result;
    }

    public String buildURLFromSegments(List<String> segments) {
        StringBuilder result = new StringBuilder();
        if (this.hasLeadingSlash()) {
            result.append("/");
        }
        for (int i = 0; i < segments.size(); ++i) {
            String segment = segments.get(i);
            result.append(segment);
            if (i >= segments.size() - 1) continue;
            result.append("/");
        }
        if (this.hasTrailingSlash() && (!segments.isEmpty() || result.indexOf("/") < 0)) {
            result.append("/");
        }
        return result.toString();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean hasTrailingSlash() {
        return this.trailingSlash;
    }

    public void setTrailingSlash(boolean trailingSlash) {
        this.trailingSlash = trailingSlash;
    }

    public boolean hasLeadingSlash() {
        return this.leadingSlash;
    }

    public void setLeadingSlash(boolean leadingSlash) {
        this.leadingSlash = leadingSlash;
    }
}

