/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.config.response;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.ocpsoft.common.util.Streams;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.servlet.config.response.ResponseContent;
import org.ocpsoft.rewrite.servlet.config.response.ResponseContentInterceptor;
import org.ocpsoft.rewrite.servlet.config.response.ResponseContentInterceptorChain;
import org.ocpsoft.rewrite.servlet.http.event.HttpServletRewrite;

public class GZipResponseContentInterceptor
implements ResponseContentInterceptor {
    @Override
    public void intercept(HttpServletRewrite event, ResponseContent buffer, ResponseContentInterceptorChain chain) {
        chain.proceed();
        byte[] contents = buffer.getContents();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(result);
            Streams.copy(new ByteArrayInputStream(contents), gzip);
            gzip.close();
            contents = result.toByteArray();
            buffer.setContents(contents);
            ((HttpServletResponse)event.getResponse()).setContentLength(contents.length);
            ((HttpServletResponse)event.getResponse()).addHeader("Content-Encoding", "gzip");
        }
        catch (IOException e) {
            throw new RewriteException("Failed to GZIP compress output content: ", e);
        }
    }
}

