/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.urlbuilder;

import java.util.Map;
import org.ocpsoft.urlbuilder.Address;
import org.ocpsoft.urlbuilder.AddressBuilder;
import org.ocpsoft.urlbuilder.Parameter;
import org.ocpsoft.urlbuilder.util.CaptureType;
import org.ocpsoft.urlbuilder.util.CapturingGroup;
import org.ocpsoft.urlbuilder.util.Encoder;
import org.ocpsoft.urlbuilder.util.ParseTools;

class AddressResult
implements Address {
    private final String protocol;
    private final String schemeSpecificPart;
    private final String host;
    private final Integer port;
    private final String path;
    private final String query;
    private final String anchor;
    private CharSequence result;

    public AddressResult(AddressBuilder parent) {
        this.protocol = this.isSet(parent.scheme) ? this.parameterize(parent.parameters, parent.scheme).toString() : null;
        this.schemeSpecificPart = this.isSet(parent.schemeSpecificPart) ? this.parameterize(parent.parameters, parent.schemeSpecificPart, false).toString() : null;
        this.host = this.isSet(parent.domain) ? this.parameterize(parent.parameters, parent.domain).toString() : null;
        this.port = this.isSet(parent.port) ? parent.port : null;
        if (this.isSet(parent.path)) {
            CharSequence path = this.parameterize(parent.parameters, parent.path);
            if (path.charAt(0) != '/') {
                path = new StringBuilder(47).append(path);
            }
            this.path = path.toString();
        } else {
            this.path = null;
        }
        this.query = this.isSet(parent.queries) ? this.toQuery(parent.queries).toString() : null;
        this.anchor = this.isSetOrEmpty(parent.anchor) ? this.parameterize(parent.parameters, parent.anchor).toString() : null;
    }

    private CharSequence toQuery(Map<CharSequence, Parameter> queries) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (CharSequence name : queries.keySet()) {
            Parameter parameter = queries.get(name);
            if (!first) {
                result.append('&');
            } else {
                first = false;
            }
            result.append(name);
            if (parameter.getValueCount() <= 0) continue;
            for (int i = 0; i < parameter.getValueCount(); ++i) {
                String value = parameter.getValueAsQueryParam(i);
                if (value != null) {
                    result.append('=').append(value);
                }
                if (i >= parameter.getValueCount() - 1) continue;
                result.append('&').append(name);
            }
        }
        return result;
    }

    public String toString() {
        if (this.result == null) {
            StringBuilder result = new StringBuilder();
            if (this.isSchemeSet()) {
                result.append(this.getScheme()).append(":");
            }
            if (this.isSchemeSpecificPartSet()) {
                result.append(this.getSchemeSpecificPart());
            } else {
                if (this.isDomainSet()) {
                    result.append("//").append(this.getDomain());
                }
                if (this.isPortSet()) {
                    result.append(":").append(this.getPort());
                }
                if (this.isPathSet()) {
                    result.append(this.getPath());
                }
                if (this.isQuerySet()) {
                    result.append('?').append(this.getQuery());
                }
                if (this.isAnchorSet()) {
                    result.append('#').append(this.getAnchor());
                }
            }
            this.result = result;
        }
        return this.result.toString();
    }

    private CharSequence parameterize(Map<CharSequence, Parameter> parameters, CharSequence sequence) {
        return this.parameterize(parameters, sequence, true);
    }

    private CharSequence parameterize(Map<CharSequence, Parameter> parameters, CharSequence sequence, boolean encodeSequence) {
        CharSequence subSequence;
        int cursor;
        StringBuilder result = new StringBuilder();
        int lastEnd = 0;
        block3: for (cursor = 0; cursor < sequence.length(); ++cursor) {
            switch (sequence.charAt(cursor)) {
                case '{': {
                    subSequence = sequence.subSequence(lastEnd, cursor);
                    if (encodeSequence) {
                        subSequence = Encoder.path(subSequence);
                    }
                    result.append(subSequence);
                    int startPos = cursor;
                    CapturingGroup group = ParseTools.balancedCapture(sequence, startPos, sequence.length() - 1, CaptureType.BRACE);
                    cursor = group.getEnd();
                    lastEnd = group.getEnd() + 1;
                    String name = group.getCaptured().toString();
                    Parameter parameter = parameters.get(name);
                    if (parameter == null || !parameter.hasValues()) {
                        throw new IllegalStateException("No parameter [" + name + "] was set in the pattern [" + sequence + "]. Call address.set(\"" + name + "\", value); or remove the parameter from the pattern.");
                    }
                    result.append(parameter.getValueAsPathParam(0));
                    continue block3;
                }
            }
        }
        if (cursor >= lastEnd) {
            subSequence = sequence.subSequence(lastEnd, cursor);
            if (encodeSequence) {
                subSequence = Encoder.path(subSequence);
            }
            result.append(subSequence);
        }
        return result;
    }

    private boolean isSet(Integer port) {
        return port != null;
    }

    private boolean isSet(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    private boolean isSet(CharSequence value) {
        return value != null && value.length() > 0;
    }

    private boolean isSetOrEmpty(CharSequence value) {
        return value != null;
    }

    @Override
    public String getAnchor() {
        return this.anchor;
    }

    @Override
    public boolean isAnchorSet() {
        return this.isSetOrEmpty(this.anchor);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getPathAndQuery() {
        StringBuilder result = new StringBuilder();
        if (this.isPathSet()) {
            result.append(this.getPath());
        }
        if (this.isQuerySet()) {
            result.append('?').append(this.getQuery());
        }
        return result.toString();
    }

    @Override
    public boolean isPathSet() {
        return this.isSet(this.path);
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public boolean isPortSet() {
        return this.isSet(this.port);
    }

    @Override
    public String getDomain() {
        return this.host;
    }

    @Override
    public boolean isDomainSet() {
        return this.isSet(this.host);
    }

    @Override
    public String getScheme() {
        return this.protocol;
    }

    @Override
    public boolean isSchemeSet() {
        return this.isSet(this.protocol);
    }

    @Override
    public String getSchemeSpecificPart() {
        return this.schemeSpecificPart;
    }

    @Override
    public boolean isSchemeSpecificPartSet() {
        return this.isSet(this.schemeSpecificPart);
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public boolean isQuerySet() {
        return this.isSet(this.query);
    }
}

