/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.config;

import java.util.HashSet;
import java.util.Set;
import org.ocpsoft.rewrite.config.DefaultOperationBuilder;
import org.ocpsoft.rewrite.config.NoOp;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.config.OperationBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.InboundRewrite;
import org.ocpsoft.rewrite.event.OutboundRewrite;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.Parameterized;

public class Operations {
    public static OperationBuilder create() {
        return new NoOp();
    }

    public static Operation onInbound(final Operation operation) {
        return new DefaultOperationBuilderInternal(operation){

            @Override
            public void perform(Rewrite event, EvaluationContext context) {
                if (event instanceof InboundRewrite) {
                    operation.perform(event, context);
                }
            }

            public String toString() {
                return "Operations.onInbound(" + operation + ")";
            }
        };
    }

    public static Operation onOutbound(final Operation operation) {
        return new DefaultOperationBuilderInternal(operation){

            @Override
            public void perform(Rewrite event, EvaluationContext context) {
                if (event instanceof OutboundRewrite) {
                    operation.perform(event, context);
                }
            }

            public String toString() {
                return "Operations.onOutbound(" + operation + ")";
            }
        };
    }

    public static OperationBuilder wrap(final Operation operation) {
        if (operation == null) {
            return Operations.create();
        }
        if (operation instanceof OperationBuilder) {
            return (OperationBuilder)operation;
        }
        return new DefaultOperationBuilderInternal(operation){

            @Override
            public void perform(Rewrite event, EvaluationContext context) {
                operation.perform(event, context);
            }
        };
    }

    private static abstract class DefaultOperationBuilderInternal
    extends DefaultOperationBuilder
    implements Parameterized {
        private Operation operation;

        public DefaultOperationBuilderInternal(Operation operation) {
            this.operation = operation;
        }

        @Override
        public Set<String> getRequiredParameterNames() {
            HashSet<String> result = new HashSet<String>();
            if (this.operation instanceof Parameterized) {
                result.addAll(((Parameterized)((Object)this.operation)).getRequiredParameterNames());
            }
            return result;
        }

        @Override
        public void setParameterStore(ParameterStore store) {
            if (this.operation instanceof Parameterized) {
                ((Parameterized)((Object)this.operation)).setParameterStore(store);
            }
        }
    }
}

