/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.servlet.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ocpsoft.common.util.Streams;
import org.ocpsoft.logging.Logger;
import org.ocpsoft.rewrite.AbstractRewrite;
import org.ocpsoft.rewrite.exception.RewriteException;
import org.ocpsoft.rewrite.servlet.RewriteLifecycleContext;
import org.ocpsoft.rewrite.servlet.RewriteWrappedResponse;
import org.ocpsoft.rewrite.servlet.config.response.ResponseContentInterceptor;
import org.ocpsoft.rewrite.servlet.config.response.ResponseStreamWrapper;
import org.ocpsoft.rewrite.servlet.event.BaseRewrite;
import org.ocpsoft.rewrite.servlet.event.OutboundServletRewrite;
import org.ocpsoft.rewrite.servlet.impl.HttpBufferRewriteImpl;
import org.ocpsoft.rewrite.servlet.impl.ResponseContentImpl;
import org.ocpsoft.rewrite.servlet.impl.ResponseContentInterceptorChainImpl;
import org.ocpsoft.rewrite.servlet.spi.OutboundRewriteProducer;
import org.ocpsoft.rewrite.servlet.spi.RewriteLifecycleListener;
import org.ocpsoft.rewrite.spi.RewriteProvider;
import org.ocpsoft.urlbuilder.Address;
import org.ocpsoft.urlbuilder.AddressBuilder;

public class HttpRewriteWrappedResponse
extends RewriteWrappedResponse {
    private final HttpServletRequest request;
    private final ServletContext servletContext;
    private static final Logger log = Logger.getLogger(HttpRewriteWrappedResponse.class);
    private final ByteArrayOutputStream bufferedResponseContent = new ByteArrayOutputStream();
    private List<ResponseContentInterceptor> responseContentInterceptors = new ArrayList<ResponseContentInterceptor>();
    private List<ResponseStreamWrapper> responseStreamWrappers = new ArrayList<ResponseStreamWrapper>();
    private boolean contentWritten = false;
    private PrintWriter printWriter;
    private ServletOutputStream outputStream = null;
    private ServletOutputStream wrappedOutputStream = null;

    public HttpRewriteWrappedResponse(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) {
        super(request, response);
        this.request = request;
        this.servletContext = servletContext;
        if (HttpRewriteWrappedResponse.getCurrentInstance((ServletRequest)request) == null) {
            super.setCurrentInstance(this);
        }
    }

    @Override
    public boolean isResponseContentIntercepted() {
        return !this.responseContentInterceptors.isEmpty();
    }

    @Override
    public boolean isResponseStreamWrapped() {
        return !this.responseStreamWrappers.isEmpty();
    }

    @Override
    public void addContentInterceptor(ResponseContentInterceptor stage) throws IllegalStateException {
        if (this.areStreamsLocked()) {
            throw new IllegalStateException("Cannot add output buffers to response once request processing has been passed to the application.");
        }
        this.responseContentInterceptors.add(stage);
    }

    @Override
    public void addStreamWrapper(ResponseStreamWrapper wrapper) {
        if (this.areStreamsLocked()) {
            throw new IllegalStateException("Cannot add output stream wrappers to response once request processing has been passed to the application.");
        }
        this.responseStreamWrappers.add(wrapper);
    }

    private boolean areStreamsLocked() {
        return this.contentWritten;
    }

    private void lockStreams() {
        this.contentWritten = true;
    }

    @Override
    public void flushBufferedContent() {
        if (this.isResponseContentIntercepted()) {
            try {
                ServletOutputStream outputStream;
                this.bufferedResponseContent.close();
                ResponseContentImpl buffer = new ResponseContentImpl(this.bufferedResponseContent.toByteArray(), Charset.forName(this.getCharacterEncoding()));
                new ResponseContentInterceptorChainImpl(this.responseContentInterceptors).begin(new HttpBufferRewriteImpl(this.request, (HttpServletResponse)this, this.servletContext), buffer);
                if (!Charset.forName(this.getCharacterEncoding()).equals(buffer.getCharset())) {
                    this.setCharacterEncoding(buffer.getCharset().name());
                }
                ServletOutputStream servletOutputStream = outputStream = this.isResponseStreamWrapped() ? this.wrappedOutputStream : super.getOutputStream();
                if (outputStream != null) {
                    Streams.copy(new ByteArrayInputStream(buffer.getContents()), (OutputStream)outputStream);
                }
                if (this.printWriter != null) {
                    this.printWriter.close();
                }
            }
            catch (IOException e) {
                throw new RewriteException("Error occurred when flushing response content buffered by " + this.responseContentInterceptors, e);
            }
        }
    }

    @Override
    public void finishStreamWrappers() {
        if (this.isResponseStreamWrapped()) {
            HttpBufferRewriteImpl event = new HttpBufferRewriteImpl(this.request, (HttpServletResponse)this, this.servletContext);
            for (ResponseStreamWrapper wrapper : this.responseStreamWrappers) {
                wrapper.finish(event);
            }
        }
    }

    public String toString() {
        if (this.isResponseContentIntercepted()) {
            try {
                return this.bufferedResponseContent.toString(this.getCharacterEncoding());
            }
            catch (UnsupportedEncodingException e) {
                throw new RewriteException("Response accepted invalid character encoding " + this.getCharacterEncoding(), e);
            }
        }
        return super.toString();
    }

    public PrintWriter getWriter() {
        if (this.printWriter == null) {
            if (this.isResponseContentIntercepted()) {
                this.printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)this.bufferedResponseContent, Charset.forName(this.getCharacterEncoding())), true);
            } else if (this.isResponseStreamWrapped()) {
                this.printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)this.getOutputStream(), Charset.forName(this.getCharacterEncoding())), true);
            } else {
                try {
                    this.lockStreams();
                    return super.getWriter();
                }
                catch (IOException e) {
                    throw new RewriteException("Could not get response writer.", e);
                }
            }
        }
        return this.printWriter;
    }

    public ServletOutputStream getOutputStream() {
        if (this.outputStream == null) {
            if (this.isResponseContentIntercepted()) {
                this.outputStream = new RewriteServletOutputStream(this.bufferedResponseContent);
            } else {
                try {
                    this.lockStreams();
                    this.outputStream = super.getOutputStream();
                }
                catch (IOException e) {
                    throw new RewriteException("Could not get response output stream.", e);
                }
            }
            if (this.isResponseStreamWrapped() && this.wrappedOutputStream == null) {
                HttpBufferRewriteImpl event = new HttpBufferRewriteImpl(this.request, (HttpServletResponse)this, this.servletContext);
                try {
                    Object wrapped = super.getOutputStream();
                    for (ResponseStreamWrapper wrapper : this.responseStreamWrappers) {
                        wrapped = wrapper.wrap(event, (OutputStream)wrapped);
                    }
                    this.wrappedOutputStream = new RewriteServletOutputStream((OutputStream)wrapped);
                    if (!this.isResponseContentIntercepted()) {
                        this.outputStream = this.wrappedOutputStream;
                    }
                }
                catch (IOException e) {
                    throw new RewriteException("Could not get response output stream.", e);
                }
            }
        }
        return this.outputStream;
    }

    public void setContentLength(int contentLength) {
        this.lockStreams();
        if (!this.isResponseContentIntercepted()) {
            if (this.isResponseStreamWrapped()) {
                this.setHeader("X-Uncompressed-Content-Length", String.valueOf(contentLength));
            } else {
                super.setContentLength(contentLength);
            }
        }
    }

    public void flushBuffer() throws IOException {
        if (this.isResponseContentIntercepted()) {
            this.bufferedResponseContent.flush();
        } else {
            this.lockStreams();
            super.flushBuffer();
        }
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        Address address = AddressBuilder.create(url);
        OutboundServletRewrite<ServletRequest, ServletResponse, Address> event = this.rewrite(address);
        if (event.getFlow().is(BaseRewrite.ServletRewriteFlow.ABORT_REQUEST)) {
            return event.getOutboundAddress().toString();
        }
        return super.encodeRedirectURL(event.getOutboundAddress().toString());
    }

    public String encodeURL(String url) {
        Address address;
        try {
            address = AddressBuilder.create(url);
        }
        catch (IllegalArgumentException e) {
            log.warn("Skipping outbound rewriting of invalid URL: " + url);
            return super.encodeURL(url);
        }
        OutboundServletRewrite<ServletRequest, ServletResponse, Address> event = this.rewrite(address);
        if (event.getFlow().is(BaseRewrite.ServletRewriteFlow.ABORT_REQUEST)) {
            return event.getOutboundAddress().toString();
        }
        return super.encodeURL(event.getOutboundAddress().toString());
    }

    private OutboundServletRewrite<ServletRequest, ServletResponse, Address> rewrite(Address address) {
        OutboundServletRewrite<ServletRequest, ServletResponse, Object> event = null;
        try {
            RewriteLifecycleContext context = (RewriteLifecycleContext)this.request.getAttribute("_com.ocpsoft.rewrite.RequestContext");
            for (OutboundRewriteProducer<ServletRequest, ServletResponse, Object> outboundRewriteProducer : context.getOutboundProducers()) {
                if (!outboundRewriteProducer.handles(address)) continue;
                event = outboundRewriteProducer.createOutboundRewrite((ServletRequest)this.request, this.getResponse(), this.servletContext, address);
            }
            if (event == null) {
                log.warn("No instance of [" + OutboundServletRewrite.class + "] was produced. Rewriting is disabled on this outbound event.");
            } else {
                for (RewriteLifecycleListener rewriteLifecycleListener : context.getRewriteLifecycleListeners()) {
                    rewriteLifecycleListener.beforeOutboundRewrite(event);
                }
                for (RewriteProvider rewriteProvider : context.getRewriteProviders()) {
                    if (!rewriteProvider.handles(event)) continue;
                    rewriteProvider.rewrite(event);
                    if (!event.getFlow().is(BaseRewrite.ServletRewriteFlow.HANDLED)) continue;
                    break;
                }
                for (RewriteLifecycleListener rewriteLifecycleListener : context.getRewriteLifecycleListeners()) {
                    rewriteLifecycleListener.afterOutboundRewrite(event);
                }
            }
            AbstractRewrite.logEvaluatedRules(event, Logger.Level.DEBUG);
            return event;
        }
        catch (RuntimeException e) {
            if (event != null) {
                AbstractRewrite.logEvaluatedRules(event, Logger.Level.ERROR);
            }
            throw e;
        }
    }

    public void sendError(int sc, String msg) throws IOException {
        this.lockStreams();
        super.sendError(sc, msg);
    }

    public void sendError(int sc) throws IOException {
        this.lockStreams();
        super.sendError(sc);
    }

    public void sendRedirect(String location) throws IOException {
        this.lockStreams();
        super.sendRedirect(location);
    }

    public void reset() {
        this.bufferedResponseContent.reset();
        super.reset();
    }

    public void resetBuffer() {
        this.bufferedResponseContent.reset();
        super.resetBuffer();
    }

    private class RewriteServletOutputStream
    extends ServletOutputStream {
        private OutputStream stream;

        public RewriteServletOutputStream(OutputStream outputStream) {
            this.stream = outputStream;
        }

        public void write(int b) {
            try {
                this.stream.write(b);
            }
            catch (IOException e) {
                throw new RewriteException("Error writing int to stream [" + this.stream + "]", e);
            }
        }

        public void write(byte[] bytes) throws IOException {
            this.stream.write(bytes);
        }

        public void write(byte[] bytes, int off, int len) {
            try {
                this.stream.write(bytes, off, len);
            }
            catch (IOException e) {
                throw new RewriteException("Error writing bytes to stream [" + this.stream + "] at offset [" + off + "] with length [" + len + "]", e);
            }
        }

        public String toString() {
            return this.stream.toString();
        }
    }
}

